/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.pis.Xs2aCurrencyConversionInfo;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCurrencyConversionInfoMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CurrencyConversionInfoSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisCommonDecoupledService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonDecoupledService.class);
    private final PaymentAuthorisationSpi paymentAuthorisationSpi;
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final CurrencyConversionInfoSpi currencyConversionInfoSpi;
    private final SpiToXs2aCurrencyConversionInfoMapper spiToXs2aCurrencyConversionInfoMapper;

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledInitiation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId) {
        return this.proceedDecoupled(request, payment, authenticationMethodId, AuthorisationType.PIS_CREATION);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledCancellation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId) {
        return this.proceedDecoupled(request, payment, authenticationMethodId, AuthorisationType.PIS_CANCELLATION);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupled(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId, AuthorisationType authorisationType) {
        SpiResponse spiResponse;
        String authenticationId = request.getAuthorisationId();
        String paymentId = request.getPaymentId();
        PsuIdData psuData = request.getPsuData();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getPaymentId());
        SpiResponse conversionSpiResponse = null;
        switch (authorisationType) {
            case PIS_CREATION: {
                spiResponse = this.paymentAuthorisationSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationId, authenticationMethodId, (Object)payment, aspspConsentDataProvider);
                conversionSpiResponse = this.currencyConversionInfoSpi.getCurrencyConversionInfo(this.spiContextDataProvider.provideWithPsuIdData(psuData), payment, authenticationId, aspspConsentDataProvider);
                break;
            }
            case PIS_CANCELLATION: {
                spiResponse = this.paymentCancellationSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationId, authenticationMethodId, (Object)payment, aspspConsentDataProvider);
                break;
            }
            default: {
                log.info("Payment-ID [{}]. Payment Authorisation Type {} is not supported.", (Object)paymentId, (Object)authorisationType);
                throw new IllegalArgumentException("This SCA type is not supported: " + authorisationType);
            }
        }
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.warn("Payment-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. Start SPI Authorisation Decoupled SCA has failed. Error msg: {}.", new Object[]{paymentId, authenticationId, psuData.getPsuId(), errorHolder});
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.xs2aAuthorisationService.updateAuthorisationStatus(authenticationId, ScaStatus.FAILED);
            }
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authenticationId, psuData);
        }
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = Optional.ofNullable(conversionSpiResponse).map(SpiResponse::getPayload).map(this.spiToXs2aCurrencyConversionInfoMapper::toXs2aCurrencyConversionInfo).orElse(null);
        SpiAuthorisationDecoupledScaResponse spiAuthorisationDecoupledScaResponse = (SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload();
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = new Xs2aUpdatePisCommonPaymentPsuDataResponse(spiAuthorisationDecoupledScaResponse.getScaStatus(), request.getPaymentId(), request.getAuthorisationId(), psuData, xs2aCurrencyConversionInfo);
        response.setPsuMessage(spiAuthorisationDecoupledScaResponse.getPsuMessage());
        return response;
    }

    @ConstructorProperties(value={"paymentAuthorisationSpi", "paymentCancellationSpi", "spiContextDataProvider", "spiErrorMapper", "aspspConsentDataProviderFactory", "xs2aAuthorisationService", "currencyConversionInfoSpi", "spiToXs2aCurrencyConversionInfoMapper"})
    public PisCommonDecoupledService(PaymentAuthorisationSpi paymentAuthorisationSpi, PaymentCancellationSpi paymentCancellationSpi, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, Xs2aAuthorisationService xs2aAuthorisationService, CurrencyConversionInfoSpi currencyConversionInfoSpi, SpiToXs2aCurrencyConversionInfoMapper spiToXs2aCurrencyConversionInfoMapper) {
        this.paymentAuthorisationSpi = paymentAuthorisationSpi;
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.currencyConversionInfoSpi = currencyConversionInfoSpi;
        this.spiToXs2aCurrencyConversionInfoMapper = spiToXs2aCurrencyConversionInfoMapper;
    }
}

