/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.RedirectConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aConsentService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedirectPiisAuthorizationService
extends RedirectConsentAuthorizationService
implements PiisAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(RedirectPiisAuthorizationService.class);
    private final Xs2aPiisConsentService xs2aPiisConsentService;

    public RedirectPiisAuthorizationService(Xs2aAuthorisationService authorisationService, Xs2aConsentService consentService, Xs2aPiisConsentService xs2aPiisConsentService) {
        super(authorisationService, consentService);
        this.xs2aPiisConsentService = xs2aPiisConsentService;
    }

    @Override
    protected boolean isConsentAbsent(String consentId) {
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", (Object)consentId);
            return true;
        }
        return false;
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        return null;
    }
}

