/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.piis;

import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.authorization.ConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aConsentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedirectConsentAuthorizationService
implements ConsentAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(RedirectConsentAuthorizationService.class);
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aConsentService consentService;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        if (this.isConsentAbsent(consentId)) {
            return Optional.empty();
        }
        return this.consentService.createConsentAuthorisation(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            resp.setInternalRequestId(auth.getInternalRequestId());
            return resp;
        });
    }

    protected abstract boolean isConsentAbsent(String var1);

    @Override
    public Optional<Authorisation> getConsentAuthorizationById(String authorizationId) {
        return this.authorisationService.getAuthorisationById(authorizationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.consentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.REDIRECT;
    }

    @ConstructorProperties(value={"authorisationService", "consentService"})
    public RedirectConsentAuthorizationService(Xs2aAuthorisationService authorisationService, Xs2aConsentService consentService) {
        this.authorisationService = authorisationService;
        this.consentService = consentService;
    }
}

