/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aAuthorisationService.class);
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2aAuthenticationObjectToCmsScaMethodMapper;

    public Optional<CreateAuthorisationResponse> createAuthorisation(CreateAuthorisationRequest request, String parentId, AuthorisationType authorisationType) {
        CmsResponse authorisationResponse = this.authorisationServiceEncrypted.createAuthorisation(new AuthorisationParentHolder(authorisationType, parentId), request);
        if (authorisationResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((CreateAuthorisationResponse)authorisationResponse.getPayload());
    }

    public Optional<Authorisation> getAuthorisationById(String authorisationId) {
        CmsResponse authorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        if (authorisationResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Authorisation)authorisationResponse.getPayload());
    }

    public void updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        this.authorisationServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<AuthenticationObject> methods) {
        CmsResponse response = this.authorisationServiceEncrypted.saveAuthenticationMethods(authorisationId, this.xs2aAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        CmsResponse response = this.authorisationServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        this.authorisationServiceEncrypted.updateAuthorisationStatus(authorisationId, scaStatus);
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaApproach(authorisationId);
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((AuthorisationScaApproachResponse)response.getPayload());
    }

    public Optional<List<String>> getAuthorisationSubResources(String parentId, AuthorisationType authorisationType) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationsByParentId(new AuthorisationParentHolder(authorisationType, parentId));
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((List)response.getPayload());
    }

    public CmsResponse<Authorisation> updateAuthorisation(UpdateAuthorisationRequest request, String authorisationId) {
        return this.authorisationServiceEncrypted.updateAuthorisation(authorisationId, request);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String authorisationId, String parentId, AuthorisationType authorisationType) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaStatus(authorisationId, new AuthorisationParentHolder(authorisationType, parentId));
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ScaStatus)response.getPayload());
    }

    @ConstructorProperties(value={"authorisationServiceEncrypted", "xs2aAuthenticationObjectToCmsScaMethodMapper"})
    public Xs2aAuthorisationService(AuthorisationServiceEncrypted authorisationServiceEncrypted, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2aAuthenticationObjectToCmsScaMethodMapper) {
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.xs2aAuthenticationObjectToCmsScaMethodMapper = xs2aAuthenticationObjectToCmsScaMethodMapper;
    }
}

