/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.service.authorization.processor.AuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.AuthorisationProcessorServiceProvider;
import de.adorsys.psd2.xs2a.service.authorization.processor.ExemptedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.FailedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.FinalisedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.PsuAuthenticatedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.PsuIdentifiedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.ReceivedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.ScaMethodSelectedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.StartedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationChainResponsibilityService {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationChainResponsibilityService.class);
    private AuthorisationProcessor receivedAuthorisationProcessor;
    private AuthorisationProcessorServiceProvider provider;

    @Autowired
    public AuthorisationChainResponsibilityService(AuthorisationProcessorServiceProvider provider) {
        this.provider = provider;
        this.initAuthorisationChains();
    }

    public AuthorisationProcessorResponse apply(AuthorisationProcessorRequest request) {
        return this.receivedAuthorisationProcessor.apply(request);
    }

    private void initAuthorisationChains() {
        this.receivedAuthorisationProcessor = new ReceivedAuthorisationProcessor(this.provider);
        PsuIdentifiedAuthorisationProcessor psuIdentifiedAuthorisationProcessor = new PsuIdentifiedAuthorisationProcessor(this.provider);
        PsuAuthenticatedAuthorisationProcessor psuAuthenticatedAuthorisationProcessor = new PsuAuthenticatedAuthorisationProcessor(this.provider);
        ScaMethodSelectedAuthorisationProcessor scaMethodSelectedAuthorisationProcessor = new ScaMethodSelectedAuthorisationProcessor(this.provider);
        StartedAuthorisationProcessor startedAuthorisationProcessor = new StartedAuthorisationProcessor(this.provider);
        FinalisedAuthorisationProcessor finalisedAuthorisationProcessor = new FinalisedAuthorisationProcessor(this.provider);
        FailedAuthorisationProcessor failedAuthorisationProcessor = new FailedAuthorisationProcessor(this.provider);
        ExemptedAuthorisationProcessor exemptedAuthorisationProcessor = new ExemptedAuthorisationProcessor(this.provider);
        this.receivedAuthorisationProcessor.setNext(psuIdentifiedAuthorisationProcessor);
        psuIdentifiedAuthorisationProcessor.setNext(psuAuthenticatedAuthorisationProcessor);
        psuAuthenticatedAuthorisationProcessor.setNext(scaMethodSelectedAuthorisationProcessor);
        scaMethodSelectedAuthorisationProcessor.setNext(startedAuthorisationProcessor);
        startedAuthorisationProcessor.setNext(finalisedAuthorisationProcessor);
        finalisedAuthorisationProcessor.setNext(failedAuthorisationProcessor);
        failedAuthorisationProcessor.setNext(exemptedAuthorisationProcessor);
    }
}

