/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.authorization.ConsentAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aConsentService;
import de.adorsys.psd2.xs2a.service.mapper.ConsentPsuDataMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsentAuthorizationService<T>
implements ConsentAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AbstractConsentAuthorizationService.class);
    private final Xs2aConsentService consentService;
    private final Xs2aAuthorisationService authorisationService;
    private final ConsentPsuDataMapper consentPsuDataMapper;

    protected abstract Optional<T> getConsentById(String var1);

    protected abstract void updateConsentAuthorisation(UpdateConsentPsuDataReq var1);

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        Optional<T> consentOptional = this.getConsentById(consentId);
        if (consentOptional.isEmpty()) {
            log.info("Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", (Object)consentId);
            return Optional.empty();
        }
        return this.consentService.createConsentAuthorisation(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            return resp;
        });
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        if (response.hasError()) {
            log.info("Consent-ID [{}], Authentication-ID [{}], PSU-ID [{}]. Update consent authorisation has failed. Error msg: {}.", new Object[]{request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData().getPsuId(), response.getErrorHolder()});
        } else {
            this.updateConsentAuthorisation(this.consentPsuDataMapper.mapToUpdateConsentPsuDataReq(request, response));
        }
        return response;
    }

    @Override
    public Optional<Authorisation> getConsentAuthorizationById(String authorisationId) {
        return this.authorisationService.getAuthorisationById(authorisationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.consentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @ConstructorProperties(value={"consentService", "authorisationService", "consentPsuDataMapper"})
    public AbstractConsentAuthorizationService(Xs2aConsentService consentService, Xs2aAuthorisationService authorisationService, ConsentPsuDataMapper consentPsuDataMapper) {
        this.consentService = consentService;
        this.authorisationService = authorisationService;
        this.consentPsuDataMapper = consentPsuDataMapper;
    }
}

