/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConfirmationOfFundsConsentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.service.ConfirmationOfFundsConsentValidationService;
import de.adorsys.psd2.xs2a.service.PsuIdDataAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorisationConfirmationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.PiisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import de.adorsys.psd2.xs2a.service.event.EventAuthorisationType;
import de.adorsys.psd2.xs2a.service.event.EventTypeService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.validator.ConsentEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentAuthorisationObject;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentAuthorisationService.class);
    private static final MessageError PIIS_CONSENT_NOT_FOUND_MESSAGE_ERROR = new MessageError(ErrorType.PIIS_403, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)});
    private final Xs2aEventService xs2aEventService;
    private final Xs2aPiisConsentService xs2aPiisConsentService;
    private final PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver;
    private final ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService;
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final ConsentEndpointAccessCheckerService endpointAccessCheckerService;
    private final PiisAuthorisationConfirmationService piisAuthorisationConfirmationService;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;
    private final LoggingContextService loggingContextService;
    private final PsuIdDataAuthorisationService psuIdDataAuthorisationService;
    private final Xs2aAuthorisationService authorisationService;
    private final EventTypeService eventTypeService;

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        boolean confirmationCodeReceived;
        this.xs2aEventService.recordConsentTppRequest(updatePsuData.getConsentId(), this.eventTypeService.getEventType(updatePsuData, EventAuthorisationType.PIIS), updatePsuData);
        String consentId = updatePsuData.getConsentId();
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Update consent PSU data failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        String authorisationId = updatePsuData.getAuthorizationId();
        if (!this.endpointAccessCheckerService.isEndpointAccessible(authorisationId, confirmationCodeReceived = StringUtils.isNotBlank((CharSequence)updatePsuData.getConfirmationCode()))) {
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data failed: update endpoint is blocked for current authorisation", (Object)consentId, (Object)authorisationId);
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SERVICE_BLOCKED)).build();
        }
        PiisConsent piisConsent = piisConsentOptional.get();
        this.loggingContextService.storeConsentStatus(piisConsent.getConsentStatus());
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentPsuDataOnUpdate(piisConsent, updatePsuData);
        if (validationResult.isNotValid()) {
            MessageErrorCode messageErrorCode = validationResult.getMessageError().getTppMessage().getMessageErrorCode();
            if (EnumSet.of(MessageErrorCode.PSU_CREDENTIALS_INVALID, MessageErrorCode.FORMAT_ERROR_NO_PSU).contains(messageErrorCode)) {
                this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Update consent PSU data - validation failed: {}", new Object[]{consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (piisConsent.isExpired()) {
            log.info("Consent-ID: [{}]. Update consent PSU data failed: consent expired", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return this.getUpdateConsentPsuDataResponse(updatePsuData);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData) {
        PiisAuthorizationService service = (PiisAuthorizationService)this.piisScaAuthorisationServiceResolver.getService(updatePsuData.getAuthorizationId());
        Optional<Authorisation> authorizationOptional = service.getConsentAuthorizationById(updatePsuData.getAuthorizationId());
        if (authorizationOptional.isEmpty()) {
            log.info("Authorisation-ID: [{}]. Update consent PSU data failed: authorisation not found by id", (Object)updatePsuData.getAuthorizationId());
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        Authorisation authorisation = authorizationOptional.get();
        if (authorisation.getChosenScaApproach() == ScaApproach.REDIRECT) {
            return this.piisAuthorisationConfirmationService.processAuthorisationConfirmation(updatePsuData);
        }
        UpdateConsentPsuDataResponse response = (UpdateConsentPsuDataResponse)this.authorisationChainResponsibilityService.apply(new PiisAuthorisationProcessorRequest(authorisation.getChosenScaApproach(), authorisation.getScaStatus(), updatePsuData, authorisation));
        this.loggingContextService.storeScaStatus(response.getScaStatus());
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getErrorHolder()).map(e -> ResponseObject.builder().fail((ErrorHolder)e).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(ErrorType.PIIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<AuthorisationResponse> createPiisAuthorisation(PsuIdData psuData, String consentId, String password) {
        ResponseObject<CreateConsentAuthorizationResponse> createPiisAuthorizationResponse = this.createConsentAuthorizationWithResponse(psuData, consentId);
        if (createPiisAuthorizationResponse.hasError()) {
            return ResponseObject.builder().fail(createPiisAuthorizationResponse.getError()).build();
        }
        PsuIdData psuIdDataFromResponse = createPiisAuthorizationResponse.getBody().getPsuIdData();
        if (psuIdDataFromResponse == null || psuIdDataFromResponse.isEmpty() || StringUtils.isBlank((CharSequence)password)) {
            this.loggingContextService.storeScaStatus(createPiisAuthorizationResponse.getBody().getScaStatus());
            return ResponseObject.builder().body(createPiisAuthorizationResponse.getBody()).build();
        }
        String authorisationId = createPiisAuthorizationResponse.getBody().getAuthorisationId();
        UpdateConsentPsuDataReq updatePsuData = new UpdateConsentPsuDataReq();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorisationId);
        updatePsuData.setPassword(password);
        ResponseObject<UpdateConsentPsuDataResponse> updatePsuDataResponse = this.updateConsentPsuData(updatePsuData);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    private ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuDataFromRequest, String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.START_PIIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Create consent authorisation with response failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(PIIS_CONSENT_NOT_FOUND_MESSAGE_ERROR).build();
        }
        PiisConsent piisConsent = piisConsentOptional.get();
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentAuthorisationOnCreate(new CreatePiisConsentAuthorisationObject(piisConsent, psuDataFromRequest));
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Create consent authorisation with response - validation failed: {}", (Object)consentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PiisAuthorizationService service = (PiisAuthorizationService)this.piisScaAuthorisationServiceResolver.getService();
        PsuIdData psuIdData = this.getActualPsuData(psuDataFromRequest, piisConsent);
        return service.createConsentAuthorization(psuIdData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(PIIS_CONSENT_NOT_FOUND_MESSAGE_ERROR)::build);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent initiation authorisations failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(PIIS_CONSENT_NOT_FOUND_MESSAGE_ERROR).build();
        }
        PiisConsent piisConsent = piisConsentOptional.get();
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentAuthorisationOnGettingById(piisConsent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Get consent authorisations - validation failed: {}", (Object)consentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        return this.getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(() -> {
            log.info("Consent-ID: [{}]. Get consent initiation authorisations failed: authorisation not found at CMS by consent id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    public ResponseObject<ConfirmationOfFundsConsentScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(PIIS_CONSENT_NOT_FOUND_MESSAGE_ERROR).build();
        }
        PiisConsent piisConsent = piisConsentOptional.get();
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentAuthorisationScaStatus(piisConsent, authorisationId);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}], Authorisation-ID [{}]. Get consent authorisation SCA status - validation failed: {}", new Object[]{consentId, authorisationId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PiisAuthorizationService authorizationService = (PiisAuthorizationService)this.piisScaAuthorisationServiceResolver.getService(authorisationId);
        Optional<ScaStatus> scaStatusOptional = authorizationService.getAuthorisationScaStatus(consentId, authorisationId);
        if (scaStatusOptional.isEmpty()) {
            log.info("Consent-ID: [{}]. Get consent authorisation SCA status failed: consent not found at CMS by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        ScaStatus scaStatus = scaStatusOptional.get();
        PsuIdData psuIdData = this.psuIdDataAuthorisationService.getPsuIdData(authorisationId, piisConsent.getPsuIdDataList());
        ConfirmationOfFundsConsentScaStatus consentScaStatus = new ConfirmationOfFundsConsentScaStatus(psuIdData, piisConsent, scaStatus);
        return ResponseObject.builder().body(consentScaStatus).build();
    }

    private Optional<Xs2aAuthorisationSubResources> getAuthorisationSubResources(String consentId) {
        return this.authorisationService.getAuthorisationSubResources(consentId, AuthorisationType.CONSENT).map(Xs2aAuthorisationSubResources::new);
    }

    private PsuIdData getActualPsuData(PsuIdData psuDataFromRequest, PiisConsent piisConsent) {
        boolean isMultilevel = piisConsent.isMultilevelScaRequired();
        if (psuDataFromRequest.isNotEmpty() || isMultilevel) {
            return psuDataFromRequest;
        }
        return piisConsent.getPsuIdDataList().stream().findFirst().orElse(psuDataFromRequest);
    }

    @ConstructorProperties(value={"xs2aEventService", "xs2aPiisConsentService", "piisScaAuthorisationServiceResolver", "confirmationOfFundsConsentValidationService", "xs2aAuthorisationService", "endpointAccessCheckerService", "piisAuthorisationConfirmationService", "authorisationChainResponsibilityService", "loggingContextService", "psuIdDataAuthorisationService", "authorisationService", "eventTypeService"})
    public PiisConsentAuthorisationService(Xs2aEventService xs2aEventService, Xs2aPiisConsentService xs2aPiisConsentService, PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver, ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService, Xs2aAuthorisationService xs2aAuthorisationService, ConsentEndpointAccessCheckerService endpointAccessCheckerService, PiisAuthorisationConfirmationService piisAuthorisationConfirmationService, AuthorisationChainResponsibilityService authorisationChainResponsibilityService, LoggingContextService loggingContextService, PsuIdDataAuthorisationService psuIdDataAuthorisationService, Xs2aAuthorisationService authorisationService, EventTypeService eventTypeService) {
        this.xs2aEventService = xs2aEventService;
        this.xs2aPiisConsentService = xs2aPiisConsentService;
        this.piisScaAuthorisationServiceResolver = piisScaAuthorisationServiceResolver;
        this.confirmationOfFundsConsentValidationService = confirmationOfFundsConsentValidationService;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.endpointAccessCheckerService = endpointAccessCheckerService;
        this.piisAuthorisationConfirmationService = piisAuthorisationConfirmationService;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
        this.loggingContextService = loggingContextService;
        this.psuIdDataAuthorisationService = psuIdDataAuthorisationService;
        this.authorisationService = authorisationService;
        this.eventTypeService = eventTypeService;
    }
}

