/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class BulkPayment
extends CommonPayment
implements AccountReferenceCollector {
    @NotNull
    private AccountReference debtorAccount;
    private String debtorName;
    private LocalDate requestedExecutionDate;
    private OffsetDateTime requestedExecutionTime;
    private List<SinglePayment> payments;
    private Boolean batchBookingPreferred;

    @Override
    public Set<AccountReference> getAccountReferences() {
        Set<AccountReference> accountReferences = this.payments.stream().map(SinglePayment::getAccountReferences).flatMap(Collection::stream).collect(Collectors.toSet());
        accountReferences.add(this.debtorAccount);
        return accountReferences;
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.BULK;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public List<SinglePayment> getPayments() {
        return this.payments;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setPayments(List<SinglePayment> payments) {
        this.payments = payments;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    @Override
    public String toString() {
        return "BulkPayment(debtorAccount=" + this.getDebtorAccount() + ", debtorName=" + this.getDebtorName() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", payments=" + this.getPayments() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkPayment)) {
            return false;
        }
        BulkPayment other = (BulkPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        OffsetDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        OffsetDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        List<SinglePayment> this$payments = this.getPayments();
        List<SinglePayment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        return !(this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BulkPayment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        OffsetDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        List<SinglePayment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        return result;
    }
}

