/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class UpdatePisCancellationPsuDataLinks
extends AbstractLinks {
    private final ScaApproachResolver scaApproachResolver;

    public UpdatePisCancellationPsuDataLinks(String httpUrl, ScaApproachResolver scaApproachResolver, Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaStatus scaStatus, AuthenticationObject chosenScaMethod) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        HrefType authorisationLink = this.buildAuthorisationLink(request);
        this.setScaStatus(authorisationLink);
        if (this.isScaStatusMethodAuthenticated(scaStatus)) {
            this.setSelectAuthenticationMethod(authorisationLink);
        } else if (this.isScaStatusMethodSelected(chosenScaMethod, scaStatus) || this.isDecoupledScaApproach(request)) {
            this.setAuthoriseTransaction(authorisationLink);
        } else if (this.isScaStatusMethodIdentified(scaStatus)) {
            this.setUpdatePsuAuthentication(authorisationLink);
        }
    }

    private HrefType buildAuthorisationLink(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        return this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", request.getPaymentService().getValue(), request.getPaymentProduct(), request.getPaymentId(), request.getAuthorisationId());
    }

    private boolean isDecoupledScaApproach(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        return this.scaApproachResolver.getScaApproach(request.getAuthorisationId()) == ScaApproach.DECOUPLED;
    }
}

