/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.validator.payment.PaymentBusinessValidator;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.PsuDataInInitialRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.TppNotificationDataValidator;
import de.adorsys.psd2.xs2a.service.validator.TppUriHeaderValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.dto.CreatePaymentRequestObject;
import de.adorsys.psd2.xs2a.validator.payment.CountryPaymentValidatorResolver;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePaymentValidator
implements BusinessValidator<CreatePaymentRequestObject> {
    private static final Logger log = LoggerFactory.getLogger(CreatePaymentValidator.class);
    private final PsuDataInInitialRequestValidator psuDataInInitialRequestValidator;
    private final CountryPaymentValidatorResolver countryPaymentValidatorResolver;
    private final TppUriHeaderValidator tppUriHeaderValidator;
    private final TppNotificationDataValidator tppNotificationDataValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreatePaymentRequestObject createPaymentRequestObject) {
        PaymentInitiationParameters paymentInitiationParameters = createPaymentRequestObject.getPaymentInitiationParameters();
        ValidationResult psuDataValidationResult = this.psuDataInInitialRequestValidator.validate(paymentInitiationParameters.getPsuData());
        if (psuDataValidationResult.isNotValid()) {
            return psuDataValidationResult;
        }
        PaymentType paymentType = paymentInitiationParameters.getPaymentType();
        String paymentProduct = paymentInitiationParameters.getPaymentProduct();
        PaymentBusinessValidator countrySpecificBusinessValidator = this.countryPaymentValidatorResolver.getPaymentBusinessValidator();
        return countrySpecificBusinessValidator.validate(createPaymentRequestObject.getPayment(), paymentProduct, paymentType);
    }

    @Override
    @NotNull
    public Set<TppMessageInformation> buildWarningMessages(@NotNull CreatePaymentRequestObject createPaymentRequestObject) {
        HashSet<TppMessageInformation> warnings = new HashSet<TppMessageInformation>();
        warnings.addAll(this.tppUriHeaderValidator.buildWarningMessages(createPaymentRequestObject.getPaymentInitiationParameters().getTppRedirectUri()));
        warnings.addAll(this.tppNotificationDataValidator.buildWarningMessages(createPaymentRequestObject.getPaymentInitiationParameters().getTppNotificationData()));
        return warnings;
    }

    @ConstructorProperties(value={"psuDataInInitialRequestValidator", "countryPaymentValidatorResolver", "tppUriHeaderValidator", "tppNotificationDataValidator"})
    public CreatePaymentValidator(PsuDataInInitialRequestValidator psuDataInInitialRequestValidator, CountryPaymentValidatorResolver countryPaymentValidatorResolver, TppUriHeaderValidator tppUriHeaderValidator, TppNotificationDataValidator tppNotificationDataValidator) {
        this.psuDataInInitialRequestValidator = psuDataInInitialRequestValidator;
        this.countryPaymentValidatorResolver = countryPaymentValidatorResolver;
        this.tppUriHeaderValidator = tppUriHeaderValidator;
        this.tppNotificationDataValidator = tppNotificationDataValidator;
    }
}

