/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.spi;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InitialSpiAspspConsentDataProvider
implements SpiAspspConsentDataProvider {
    private final AspspDataService aspspDataService;
    private byte[] aspspConsentData = ArrayUtils.EMPTY_BYTE_ARRAY;
    private String encryptedConsentId;

    @NotNull
    public byte[] loadAspspConsentData() {
        return Arrays.copyOf(this.aspspConsentData, this.aspspConsentData.length);
    }

    public void updateAspspConsentData(byte[] aspspConsentData) {
        this.aspspConsentData = aspspConsentData;
        if (StringUtils.isNotBlank((CharSequence)this.encryptedConsentId)) {
            this.updateAspspConsentDataOnServer();
        }
    }

    public void clearAspspConsentData() {
        this.aspspConsentData = ArrayUtils.EMPTY_BYTE_ARRAY;
        if (StringUtils.isNotBlank((CharSequence)this.encryptedConsentId)) {
            this.aspspDataService.deleteAspspConsentData(this.encryptedConsentId);
        }
    }

    public void saveWith(@NotNull String encryptedConsentId) {
        this.encryptedConsentId = encryptedConsentId;
        this.updateAspspConsentDataOnServer();
    }

    private void updateAspspConsentDataOnServer() {
        if (Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, this.aspspConsentData)) {
            this.aspspDataService.deleteAspspConsentData(this.encryptedConsentId);
        } else {
            this.aspspDataService.updateAspspConsentData(new AspspConsentData(this.aspspConsentData, this.encryptedConsentId));
        }
    }

    @ConstructorProperties(value={"aspspDataService"})
    InitialSpiAspspConsentDataProvider(AspspDataService aspspDataService) {
        this.aspspDataService = aspspDataService;
    }
}

