/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.OtpFormat;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aChallengeDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiChallengeData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiOtpFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aChallengeDataMapperImpl
implements SpiToXs2aChallengeDataMapper {
    @Override
    public ChallengeData toChallengeData(SpiChallengeData spiChallengeData) {
        List list;
        if (spiChallengeData == null) {
            return null;
        }
        ChallengeData challengeData = new ChallengeData();
        byte[] image = spiChallengeData.getImage();
        if (image != null) {
            challengeData.setImage(Arrays.copyOf(image, image.length));
        }
        if ((list = spiChallengeData.getData()) != null) {
            challengeData.setData(new ArrayList(list));
        }
        challengeData.setImageLink(spiChallengeData.getImageLink());
        challengeData.setOtpMaxLength(spiChallengeData.getOtpMaxLength());
        challengeData.setOtpFormat(this.spiOtpFormatToOtpFormat(spiChallengeData.getOtpFormat()));
        challengeData.setAdditionalInformation(spiChallengeData.getAdditionalInformation());
        return challengeData;
    }

    protected OtpFormat spiOtpFormatToOtpFormat(SpiOtpFormat spiOtpFormat) {
        OtpFormat otpFormat;
        if (spiOtpFormat == null) {
            return null;
        }
        switch (spiOtpFormat) {
            case CHARACTERS: {
                otpFormat = OtpFormat.CHARACTERS;
                break;
            }
            case INTEGER: {
                otpFormat = OtpFormat.INTEGER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + spiOtpFormat);
            }
        }
        return otpFormat;
    }
}

