/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.ais;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error415.Error415NGAIS;
import de.adorsys.psd2.xs2a.exception.model.error415.TppMessage415AIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AIS415ErrorMapper
extends Psd2ErrorMapper<MessageError, Error415NGAIS> {
    @Override
    public Function<MessageError, Error415NGAIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.UNSUPPORTED_MEDIA_TYPE;
    }

    private Error415NGAIS mapToPsd2Error(MessageError messageError) {
        return ((Error415NGAIS.Error415NGAISBuilder)Error415NGAIS.builder().tppMessages(this.mapToTppMessage415AIS(messageError.getTppMessages()))).build();
    }

    private List<TppMessage415AIS> mapToTppMessage415AIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> ((TppMessage415AIS.TppMessage415AISBuilder)((TppMessage415AIS.TppMessage415AISBuilder)((TppMessage415AIS.TppMessage415AISBuilder)((TppMessage415AIS.TppMessage415AISBuilder)TppMessage415AIS.builder().category(TppMessageCategory.fromValue((String)m.getCategory().name()))).code(m.getMessageErrorCode().getName())).path(m.getPath())).text(this.getErrorText((TppMessageInformation)m))).build()).collect(Collectors.toList());
    }
}

