/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.link;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.PaymentCancellationAuthorisationNeededDecider;
import de.adorsys.psd2.xs2a.service.link.BaseAspectService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import de.adorsys.psd2.xs2a.web.link.PaymentCancellationLinks;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentCancellationAspectService
extends BaseAspectService<PaymentController> {
    private final PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider;
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final RedirectIdService redirectIdService;
    private final RequestProviderService requestProviderService;

    @Autowired
    public PaymentCancellationAspectService(PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider, AspspProfileServiceWrapper aspspProfileServiceWrapper, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, AuthorisationMethodDecider authorisationMethodDecider, RedirectIdService redirectIdService, RequestProviderService requestProviderService) {
        super(aspspProfileServiceWrapper);
        this.cancellationScaNeededDecider = cancellationScaNeededDecider;
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.redirectIdService = redirectIdService;
        this.requestProviderService = requestProviderService;
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(ResponseObject<CancelPaymentResponse> result, PisPaymentCancellationRequest request) {
        CancelPaymentResponse response;
        boolean isScaRequired;
        if (!result.hasError() && this.isStartAuthorisationLinksNeeded(isScaRequired = this.cancellationScaNeededDecider.isScaRequired((response = result.getBody()).isStartAuthorisationRequired()), response.getTransactionStatus())) {
            boolean isExplicitMethod = this.authorisationMethodDecider.isExplicitMethod(request.getTppExplicitAuthorisationPreferred(), false);
            response.setLinks(new PaymentCancellationLinks(this.getHttpUrl(), this.scaApproachResolver, this.redirectLinkBuilder, this.redirectIdService, response, isExplicitMethod, this.getScaRedirectFlow(), this.isAuthorisationConfirmationRequestMandated(), this.requestProviderService.getInstanceId()));
        }
        return result;
    }

    private boolean isStartAuthorisationLinksNeeded(boolean isScaRequired, TransactionStatus transactionStatus) {
        return transactionStatus.isNotFinalisedStatus() && transactionStatus != TransactionStatus.RCVD && isScaRequired;
    }
}

