/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.ais.AbstractBalanceService;
import de.adorsys.psd2.xs2a.service.ais.AccountServicesHolder;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.AccountMappersHolder;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetCardBalancesReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountBalanceRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CardAccountSpi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardAccountBalanceService
extends AbstractBalanceService {
    private static final Logger log = LoggerFactory.getLogger(CardAccountBalanceService.class);
    private final CardAccountSpi cardAccountSpi;
    private final AccountMappersHolder accountMappersHolder;
    private final AccountServicesHolder accountServicesHolder;
    private final GetCardBalancesReportValidator getCardBalancesReportValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public CardAccountBalanceService(AccountServicesHolder accountServicesHolder, Xs2aEventService xs2aEventService, LoggingContextService loggingContextService, CardAccountSpi cardAccountSpi, AccountMappersHolder accountMappersHolder, GetCardBalancesReportValidator getCardBalancesReportValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        super(accountServicesHolder, xs2aEventService, loggingContextService);
        this.cardAccountSpi = cardAccountSpi;
        this.accountServicesHolder = accountServicesHolder;
        this.accountMappersHolder = accountMappersHolder;
        this.getCardBalancesReportValidator = getCardBalancesReportValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }

    @Override
    protected EventType getEventType() {
        return EventType.READ_CARD_BALANCE_REQUEST_RECEIVED;
    }

    @Override
    protected ValidationResult getValidationResultForCommonAccountBalanceRequest(String accountId, String requestUri, AisConsent aisConsent) {
        return this.getCardBalancesReportValidator.validate(new GetCardAccountBalanceRequestObject(aisConsent, accountId, requestUri));
    }

    @Override
    protected SpiResponse<List<SpiAccountBalance>> getSpiResponse(AisConsent aisConsent, String consentId, String accountId) {
        AccountAccess access = aisConsent.getAspspAccountAccesses();
        SpiAccountReference requestedAccountReference = this.accountServicesHolder.findAccountReference(access.getBalances(), accountId);
        return this.cardAccountSpi.requestCardBalancesForAccount(this.accountServicesHolder.getSpiContextData(), requestedAccountReference, this.accountMappersHolder.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    @Override
    protected ResponseObject<Xs2aBalancesReport> checkSpiResponse(String consentId, String accountId, SpiResponse<List<SpiAccountBalance>> spiResponse) {
        log.info("Account-ID [{}], Consent-ID: [{}]. Get card balances report failed: error on SPI level", (Object)accountId, (Object)consentId);
        return ResponseObject.builder().fail(new MessageError(this.accountMappersHolder.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
    }

    @Override
    protected ResponseObject<Xs2aBalancesReport> getXs2aBalancesReportResponseObject(AisConsent aisConsent, String accountId, String consentId, String requestUri, List<SpiAccountBalance> payload) {
        AccountAccess access = aisConsent.getAspspAccountAccesses();
        List balances = access.getBalances();
        if (this.hasNoAccessToCardSource(balances)) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_INVALID)).build();
        }
        AccountReference maskedAccountReference = this.getMaskedAccountReference(accountId, access.getBalances());
        Xs2aBalancesReport balancesReport = this.accountMappersHolder.mapToXs2aBalancesReport(maskedAccountReference, payload);
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.accountServicesHolder.consentActionLog(this.accountServicesHolder.getTppId(), consentId, this.accountServicesHolder.createActionStatus(false, TypeAccess.BALANCE, response), requestUri, this.accountServicesHolder.needsToUpdateUsage(aisConsent), accountId, null);
        return response;
    }

    private AccountReference getMaskedAccountReference(String accountId, List<AccountReference> balances) {
        AccountReference filteredAccountReference = this.filterAccountReference(balances, accountId);
        if (filteredAccountReference != null && StringUtils.isNotBlank((CharSequence)filteredAccountReference.getPan())) {
            String maskedPan = this.accountServicesHolder.hidePanInAccountReference(filteredAccountReference.getPan());
            filteredAccountReference.setPan(null);
            filteredAccountReference.setMaskedPan(maskedPan);
        }
        return filteredAccountReference;
    }

    private AccountReference filterAccountReference(List<AccountReference> references, String resourceId) {
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().orElse(null);
    }

    private boolean hasNoAccessToCardSource(List<AccountReference> references) {
        return references.stream().allMatch(AccountReference::isNotCardAccount);
    }
}

