/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.CardAccountHandler;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class AccountServicesHolder {
    private final Xs2aAisConsentService aisConsentService;
    private final TppService tppService;
    private final AccountHelperService accountHelperService;
    private final CardAccountHandler cardAccountHandler;

    public Optional<AisConsent> getAccountConsentById(String consentId) {
        return this.aisConsentService.getAccountConsentById(consentId);
    }

    public SpiAccountReference findAccountReference(List<AccountReference> accountReferences, String accountId) {
        return this.accountHelperService.findAccountReference(accountReferences, accountId);
    }

    public SpiContextData getSpiContextData() {
        return this.accountHelperService.getSpiContextData();
    }

    public String getTppId() {
        return this.tppService.getTppId();
    }

    ActionStatus createActionStatus(boolean withBalance, TypeAccess typeAccess, ResponseObject response) {
        return this.accountHelperService.createActionStatus(withBalance, typeAccess, response);
    }

    public boolean needsToUpdateUsage(AisConsent aisConsent) {
        return this.accountHelperService.needsToUpdateUsage(aisConsent);
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus, String requestUri, boolean updateUsage, String resourceId, String transactionId) {
        this.aisConsentService.consentActionLog(tppId, consentId, actionStatus, requestUri, updateUsage, resourceId, transactionId);
    }

    public String hidePanInAccountReference(String pan) {
        return this.cardAccountHandler.hidePanInAccountReference(pan);
    }

    @ConstructorProperties(value={"aisConsentService", "tppService", "accountHelperService", "cardAccountHandler"})
    public AccountServicesHolder(Xs2aAisConsentService aisConsentService, TppService tppService, AccountHelperService accountHelperService, CardAccountHandler cardAccountHandler) {
        this.aisConsentService = aisConsentService;
        this.tppService = tppService;
        this.accountHelperService = accountHelperService;
        this.cardAccountHandler = cardAccountHandler;
    }
}

