/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AuthenticationObject;
import de.adorsys.psd2.model.AuthenticationType;
import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.AuthorisationsList;
import de.adorsys.psd2.model.CancellationList;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.ConsentInformationResponse200Json;
import de.adorsys.psd2.model.ConsentStatus;
import de.adorsys.psd2.model.ConsentStatusResponse200;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.ScaMethods;
import de.adorsys.psd2.model.ScaStatus;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.UpdatePsuAuthenticationResponse;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccessType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class ConsentModelMapper {
    private final CoreObjectsMapper coreObjectsMapper;
    private final ObjectMapper objectMapper;
    public final AccountModelMapper accountModelMapper;

    public CreateConsentReq mapToCreateConsentReq(Consents consent) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createAisConsentRequest = new CreateConsentReq();
            createAisConsentRequest.setAccess(this.mapToAccountAccessInner(cnst.getAccess()));
            createAisConsentRequest.setRecurringIndicator(cnst.getRecurringIndicator());
            createAisConsentRequest.setValidUntil(cnst.getValidUntil());
            createAisConsentRequest.setFrequencyPerDay(cnst.getFrequencyPerDay());
            createAisConsentRequest.setCombinedServiceIndicator(BooleanUtils.toBoolean((Boolean)cnst.isCombinedServiceIndicator()));
            return createAisConsentRequest;
        }).orElse(null);
    }

    public ConsentStatusResponse200 mapToConsentStatusResponse200(ConsentStatusResponse consentStatusResponse) {
        return Optional.ofNullable(consentStatusResponse).map(cstr -> new ConsentStatusResponse200().consentStatus(ConsentStatus.fromValue((String)cstr.getConsentStatus()))).orElse(null);
    }

    public StartScaprocessResponse mapToStartScaProcessResponse(Xs2aCreatePisAuthorisationResponse response) {
        return Optional.ofNullable(response).map(r -> new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(r.getScaStatus())).authorisationId(r.getAuthorisationId())._links((Map)this.objectMapper.convertValue((Object)r.getLinks(), Map.class))).orElse(null);
    }

    public StartScaprocessResponse mapToStartScaProcessResponse(Xs2aCreatePisCancellationAuthorisationResponse response) {
        return new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(response.getScaStatus()))._links((Map)this.objectMapper.convertValue((Object)response.getLinks(), Map.class));
    }

    public UpdatePsuAuthenticationResponse mapToUpdatePsuAuthenticationResponse(UpdateConsentPsuDataResponse response) {
        return Optional.ofNullable(response).map(r -> new UpdatePsuAuthenticationResponse()._links((Map)this.objectMapper.convertValue((Object)response.getLinks(), Map.class)).scaMethods(this.getAvailableScaMethods(r.getAvailableScaMethods())).scaStatus((ScaStatus)Optional.ofNullable(r.getScaStatus()).map(s -> ScaStatus.valueOf((String)s.name())).orElse(null)).challengeData(this.coreObjectsMapper.mapToChallengeData(response.getChallengeData())).chosenScaMethod(this.mapToChosenScaMethod(response.getChosenScaMethodForPsd2Response())).psuMessage(r.getPsuMessage())).orElse(null);
    }

    public ConsentsResponse201 mapToConsentsResponse201(CreateConsentResponse createConsentResponse) {
        return Optional.ofNullable(createConsentResponse).map(cnst -> new ConsentsResponse201().consentStatus(ConsentStatus.fromValue((String)cnst.getConsentStatus())).consentId(cnst.getConsentId()).scaMethods(this.mapToScaMethodsOuter((CreateConsentResponse)cnst))._links((Map)this.objectMapper.convertValue((Object)cnst.getLinks(), Map.class)).message(cnst.getPsuMessage())).orElse(null);
    }

    public ConsentInformationResponse200Json mapToConsentInformationResponse200Json(AccountConsent accountConsent) {
        return Optional.ofNullable(accountConsent).map(consent -> new ConsentInformationResponse200Json().access(this.mapToAccountAccessDomain(consent.getAccess())).recurringIndicator(Boolean.valueOf(consent.isRecurringIndicator())).validUntil(consent.getValidUntil()).frequencyPerDay(Integer.valueOf(consent.getFrequencyPerDay())).lastActionDate(consent.getLastActionDate()).consentStatus(ConsentStatus.fromValue((String)consent.getConsentStatus().getValue()))).orElse(null);
    }

    public Authorisations mapToAuthorisations(Xs2aAuthorisationSubResources xs2AAuthorisationSubResources) {
        Authorisations authorisations = new Authorisations();
        AuthorisationsList authorisationsList = new AuthorisationsList();
        authorisationsList.addAll(xs2AAuthorisationSubResources.getAuthorisationIds());
        authorisations.setAuthorisationIds(authorisationsList);
        return authorisations;
    }

    private ScaMethods mapToScaMethodsOuter(CreateConsentResponse createConsentResponse) {
        List authList = Optional.ofNullable(createConsentResponse.getScaMethods()).map(arr -> Arrays.stream(arr).map(au -> new AuthenticationObject().authenticationType(AuthenticationType.fromValue((String)au.getAuthenticationType())).authenticationVersion(au.getAuthenticationVersion()).authenticationMethodId(au.getAuthenticationMethodId()).name(au.getName()).explanation(au.getExplanation())).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        ScaMethods scaMethods = new ScaMethods();
        scaMethods.addAll((Collection)authList);
        return scaMethods;
    }

    private Xs2aAccountAccess mapToAccountAccessInner(AccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(acs -> new Xs2aAccountAccess(this.mapToXs2aAccountReferences(acs.getAccounts()), this.mapToXs2aAccountReferences(acs.getBalances()), this.mapToXs2aAccountReferences(acs.getTransactions()), this.mapToAccountAccessTypeFromAvailableAccounts(acs.getAvailableAccounts()), this.mapToAccountAccessTypeFromAllPsd2Enum(acs.getAllPsd2()))).orElse(null);
    }

    private AccountAccess mapToAccountAccessDomain(Xs2aAccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(access -> {
            AccountAccess mappedAccountAccess = new AccountAccess();
            mappedAccountAccess.setAccounts(this.accountModelMapper.mapToAccountReferences(access.getAccounts()));
            mappedAccountAccess.setBalances(this.accountModelMapper.mapToAccountReferences(access.getBalances()));
            mappedAccountAccess.setTransactions(this.accountModelMapper.mapToAccountReferences(access.getTransactions()));
            mappedAccountAccess.setAvailableAccounts(AccountAccess.AvailableAccountsEnum.fromValue((String)Optional.ofNullable(access.getAvailableAccounts()).map(Xs2aAccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.fromValue((String)Optional.ofNullable(access.getAllPsd2()).map(Xs2aAccountAccessType::getDescription).orElse(null)));
            return mappedAccountAccess;
        }).orElse(null);
    }

    private Xs2aAccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> Xs2aAccountAccessType.getByDescription(en.toString())).orElse(null);
    }

    private Xs2aAccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> Xs2aAccountAccessType.getByDescription(en.toString())).orElse(null);
    }

    private List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferences(List<AccountReference> references) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(this::mapToAccountReference).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(Object reference) {
        return (de.adorsys.psd2.xs2a.core.profile.AccountReference)this.objectMapper.convertValue(reference, de.adorsys.psd2.xs2a.core.profile.AccountReference.class);
    }

    public UpdateConsentPsuDataReq mapToUpdatePsuData(PsuIdData psuData, String consentId, String authorizationId, Map body) {
        UpdateConsentPsuDataReq updatePsuData = new UpdateConsentPsuDataReq();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorizationId);
        if (!body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(o -> (LinkedHashMap)o).ifPresent(psuDataMap -> updatePsuData.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(o -> (String)o).ifPresent(updatePsuData::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).map(o -> (String)o).ifPresent(updatePsuData::setScaAuthenticationData);
        } else {
            updatePsuData.setUpdatePsuIdentification(true);
        }
        return updatePsuData;
    }

    public CancellationList mapToCancellationList(Xs2aPaymentCancellationAuthorisationSubResource idsContainer) {
        CancellationList list = new CancellationList();
        list.addAll((Collection)Optional.ofNullable(idsContainer.getCancellationIds()).map(ArrayList::new).orElseGet(ArrayList::new));
        return list;
    }

    public Xs2aUpdatePisCommonPaymentPsuDataRequest mapToPisUpdatePsuData(PsuIdData psuData, String paymentId, String authorisationId, String paymentService, String paymentProduct, Map body) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = new Xs2aUpdatePisCommonPaymentPsuDataRequest();
        request.setPsuData(psuData);
        request.setPaymentId(paymentId);
        request.setAuthorisationId(authorisationId);
        request.setPaymentService(paymentService);
        request.setPaymentProduct(paymentProduct);
        if (!body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(o -> (LinkedHashMap)o).ifPresent(psuDataMap -> request.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(o -> (String)o).ifPresent(request::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).ifPresent(authData -> request.setScaAuthenticationData((String)authData));
        } else {
            request.setUpdatePsuIdentification(true);
        }
        return request;
    }

    public UpdatePsuAuthenticationResponse mapToUpdatePsuAuthenticationResponse(Xs2aUpdatePisCommonPaymentPsuDataResponse response) {
        return new UpdatePsuAuthenticationResponse()._links((Map)this.objectMapper.convertValue((Object)response.getLinks(), Map.class)).scaMethods(this.getAvailableScaMethods(response.getAvailableScaMethods())).chosenScaMethod(this.mapToChosenScaMethod(response.getChosenScaMethodForPsd2Response())).challengeData(this.coreObjectsMapper.mapToChallengeData(response.getChallengeData())).psuMessage(response.getPsuMessage()).scaStatus(Optional.ofNullable(response.getScaStatus()).map(s -> ScaStatus.fromValue((String)s.getValue())).orElse(ScaStatus.FAILED));
    }

    private ScaMethods getAvailableScaMethods(List<Xs2aAuthenticationObject> availableScaMethods) {
        ScaMethods scaMethods = new ScaMethods();
        if (CollectionUtils.isNotEmpty(availableScaMethods)) {
            availableScaMethods.forEach(a -> scaMethods.add((Object)new AuthenticationObject().authenticationMethodId(a.getAuthenticationMethodId()).authenticationType(AuthenticationType.fromValue((String)a.getAuthenticationType())).authenticationVersion(a.getAuthenticationVersion()).name(a.getName()).explanation(a.getExplanation())));
        }
        return scaMethods;
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aAuthenticationObject xs2aAuthenticationObject) {
        return Optional.ofNullable(xs2aAuthenticationObject).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(AuthenticationType.fromValue((String)ch.getAuthenticationType()));
            method.setAuthenticationVersion(ch.getAuthenticationVersion());
            method.setName(ch.getName());
            method.setExplanation(ch.getExplanation());
            return method;
        }).orElse(null);
    }

    @ConstructorProperties(value={"coreObjectsMapper", "objectMapper", "accountModelMapper"})
    public ConsentModelMapper(CoreObjectsMapper coreObjectsMapper, ObjectMapper objectMapper, AccountModelMapper accountModelMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.objectMapper = objectMapper;
        this.accountModelMapper = accountModelMapper;
    }
}

