/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PaymentCancellationAspect
extends AbstractLinkAspect<PaymentController> {
    public PaymentCancellationAspect(ScaApproachResolver scaApproachResolver, MessageService messageService) {
        super(scaApproachResolver, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentService.cancelPayment(..)) && args( paymentType, paymentProduct, paymentId)", returning="result", argNames="result,paymentType,paymentProduct,paymentId")
    public ResponseObject<CancelPaymentResponse> cancelPayment(ResponseObject<CancelPaymentResponse> result, PaymentType paymentType, String paymentProduct, String paymentId) {
        if (!result.hasError()) {
            CancelPaymentResponse response = result.getBody();
            response.setLinks(this.buildCancellationLinks(response.isStartAuthorisationRequired(), paymentType, paymentProduct, paymentId));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildCancellationLinks(boolean startAuthorisationRequired, PaymentType paymentType, String paymentProduct, String paymentId) {
        Links links = new Links();
        if (startAuthorisationRequired) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentType.getValue(), paymentProduct, paymentId));
            links.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentType.getValue(), paymentProduct, paymentId));
            links.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentType.getValue(), paymentProduct, paymentId));
        }
        return links;
    }
}

