/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice(basePackages={"de.adorsys.psd2.xs2a.web.controller"})
public class CommonHeaderModifierAdvice
implements ResponseBodyAdvice<Object> {
    protected final ScaApproachResolver scaApproachResolver;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        response.getHeaders().add("X-Request-Id", request.getHeaders().getFirst("X-Request-Id"));
        return body;
    }

    protected boolean hasError(Object body, Class expectedClass) {
        return Optional.ofNullable(body).isPresent() && !body.getClass().isAssignableFrom(expectedClass);
    }

    @ConstructorProperties(value={"scaApproachResolver"})
    public CommonHeaderModifierAdvice(ScaApproachResolver scaApproachResolver) {
        this.scaApproachResolver = scaApproachResolver;
    }
}

