/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.header.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.xs2a.domain.ContentType;
import de.adorsys.psd2.xs2a.service.validator.header.impl.CommonRequestHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;

@ApiModel(description="Payment initiation request header", value="PaymentInitiationRequestHeader")
@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentInitiationRequestHeader
extends CommonRequestHeader {
    private static final String IP_PATTERN_v4 = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    private static final String IP_PATTERN_v6 = "^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$";
    @ApiModelProperty(value="Content type", example="application/json")
    @JsonProperty(value="content-type")
    private ContentType contentType;
    @ApiModelProperty(value="Might be mandated in the ASPSP's documentation, if OAuth is not chosen as Pre-Step", required=false, example="PSU-1234")
    @JsonProperty(value="psu-id")
    private String psuId;
    @ApiModelProperty(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.", required=false, example="type")
    @JsonProperty(value="psu-id-type")
    private String psuIdType;
    @ApiModelProperty(value="Contained if not yet contained in the first request, and mandated by the ASPSP in the related response. This field is relevant only in a corporate context", required=false, example="6558e7e6-f72f-407a-9f22-763ad0921915")
    @JsonProperty(value="psu-corporate-id")
    private String psuCorporateId;
    @ApiModelProperty(value="Might be mandated by the ASPSP in addition if the PSU-Corporate-ID is contained", required=false, example="type")
    @JsonProperty(value="psu-corporate-id-type")
    private String psuCorporateIdType;
    @ApiModelProperty(value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service. This then contains the consentId of the related AIS consent, which was performed prior to this payment initiation.", required=false, example="91306384-e37a-4536-a51e-1ced42e37a5c")
    @JsonProperty(value="consent-id")
    private String psuConsentId;
    @ApiModelProperty(value="The forwarded Agent header field of the http request between PSU and TPP", required=false, example="Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0)")
    @JsonProperty(value="psu-user-agent")
    private String psuAgent;
    @ApiModelProperty(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP", required=true, example="192.168.8.78 example")
    @JsonProperty(value="psu-ip-address")
    @Pattern(regexp="^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$")
    private @Pattern(regexp="^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$") String psuIpAddress;
    @ApiModelProperty(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP", required=false, example="GEO:52.506931,13.144558")
    @JsonProperty(value="psu-geo-location")
    private String psuGeoLocation;
    @ApiModelProperty(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect", required=false, example="https://www.example.com/authentication/b51de9d9-2baa-4012-9447-e3f57f1f363c")
    @JsonProperty(value="tpp-redirect-uri")
    private String tppRedirectUri;

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getPsuId() {
        return this.psuId;
    }

    public String getPsuIdType() {
        return this.psuIdType;
    }

    public String getPsuCorporateId() {
        return this.psuCorporateId;
    }

    public String getPsuCorporateIdType() {
        return this.psuCorporateIdType;
    }

    public String getPsuConsentId() {
        return this.psuConsentId;
    }

    public String getPsuAgent() {
        return this.psuAgent;
    }

    public String getPsuIpAddress() {
        return this.psuIpAddress;
    }

    public String getPsuGeoLocation() {
        return this.psuGeoLocation;
    }

    public String getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setPsuId(String psuId) {
        this.psuId = psuId;
    }

    public void setPsuIdType(String psuIdType) {
        this.psuIdType = psuIdType;
    }

    public void setPsuCorporateId(String psuCorporateId) {
        this.psuCorporateId = psuCorporateId;
    }

    public void setPsuCorporateIdType(String psuCorporateIdType) {
        this.psuCorporateIdType = psuCorporateIdType;
    }

    public void setPsuConsentId(String psuConsentId) {
        this.psuConsentId = psuConsentId;
    }

    public void setPsuAgent(String psuAgent) {
        this.psuAgent = psuAgent;
    }

    public void setPsuIpAddress(String psuIpAddress) {
        this.psuIpAddress = psuIpAddress;
    }

    public void setPsuGeoLocation(String psuGeoLocation) {
        this.psuGeoLocation = psuGeoLocation;
    }

    public void setTppRedirectUri(String tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    @Override
    public String toString() {
        return "PaymentInitiationRequestHeader(contentType=" + (Object)((Object)this.getContentType()) + ", psuId=" + this.getPsuId() + ", psuIdType=" + this.getPsuIdType() + ", psuCorporateId=" + this.getPsuCorporateId() + ", psuCorporateIdType=" + this.getPsuCorporateIdType() + ", psuConsentId=" + this.getPsuConsentId() + ", psuAgent=" + this.getPsuAgent() + ", psuIpAddress=" + this.getPsuIpAddress() + ", psuGeoLocation=" + this.getPsuGeoLocation() + ", tppRedirectUri=" + this.getTppRedirectUri() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentInitiationRequestHeader)) {
            return false;
        }
        PaymentInitiationRequestHeader other = (PaymentInitiationRequestHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentType this$contentType = this.getContentType();
        ContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        String this$psuId = this.getPsuId();
        String other$psuId = other.getPsuId();
        if (this$psuId == null ? other$psuId != null : !this$psuId.equals(other$psuId)) {
            return false;
        }
        String this$psuIdType = this.getPsuIdType();
        String other$psuIdType = other.getPsuIdType();
        if (this$psuIdType == null ? other$psuIdType != null : !this$psuIdType.equals(other$psuIdType)) {
            return false;
        }
        String this$psuCorporateId = this.getPsuCorporateId();
        String other$psuCorporateId = other.getPsuCorporateId();
        if (this$psuCorporateId == null ? other$psuCorporateId != null : !this$psuCorporateId.equals(other$psuCorporateId)) {
            return false;
        }
        String this$psuCorporateIdType = this.getPsuCorporateIdType();
        String other$psuCorporateIdType = other.getPsuCorporateIdType();
        if (this$psuCorporateIdType == null ? other$psuCorporateIdType != null : !this$psuCorporateIdType.equals(other$psuCorporateIdType)) {
            return false;
        }
        String this$psuConsentId = this.getPsuConsentId();
        String other$psuConsentId = other.getPsuConsentId();
        if (this$psuConsentId == null ? other$psuConsentId != null : !this$psuConsentId.equals(other$psuConsentId)) {
            return false;
        }
        String this$psuAgent = this.getPsuAgent();
        String other$psuAgent = other.getPsuAgent();
        if (this$psuAgent == null ? other$psuAgent != null : !this$psuAgent.equals(other$psuAgent)) {
            return false;
        }
        String this$psuIpAddress = this.getPsuIpAddress();
        String other$psuIpAddress = other.getPsuIpAddress();
        if (this$psuIpAddress == null ? other$psuIpAddress != null : !this$psuIpAddress.equals(other$psuIpAddress)) {
            return false;
        }
        String this$psuGeoLocation = this.getPsuGeoLocation();
        String other$psuGeoLocation = other.getPsuGeoLocation();
        if (this$psuGeoLocation == null ? other$psuGeoLocation != null : !this$psuGeoLocation.equals(other$psuGeoLocation)) {
            return false;
        }
        String this$tppRedirectUri = this.getTppRedirectUri();
        String other$tppRedirectUri = other.getTppRedirectUri();
        return !(this$tppRedirectUri == null ? other$tppRedirectUri != null : !this$tppRedirectUri.equals(other$tppRedirectUri));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaymentInitiationRequestHeader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        String $psuId = this.getPsuId();
        result = result * 59 + ($psuId == null ? 43 : $psuId.hashCode());
        String $psuIdType = this.getPsuIdType();
        result = result * 59 + ($psuIdType == null ? 43 : $psuIdType.hashCode());
        String $psuCorporateId = this.getPsuCorporateId();
        result = result * 59 + ($psuCorporateId == null ? 43 : $psuCorporateId.hashCode());
        String $psuCorporateIdType = this.getPsuCorporateIdType();
        result = result * 59 + ($psuCorporateIdType == null ? 43 : $psuCorporateIdType.hashCode());
        String $psuConsentId = this.getPsuConsentId();
        result = result * 59 + ($psuConsentId == null ? 43 : $psuConsentId.hashCode());
        String $psuAgent = this.getPsuAgent();
        result = result * 59 + ($psuAgent == null ? 43 : $psuAgent.hashCode());
        String $psuIpAddress = this.getPsuIpAddress();
        result = result * 59 + ($psuIpAddress == null ? 43 : $psuIpAddress.hashCode());
        String $psuGeoLocation = this.getPsuGeoLocation();
        result = result * 59 + ($psuGeoLocation == null ? 43 : $psuGeoLocation.hashCode());
        String $tppRedirectUri = this.getTppRedirectUri();
        result = result * 59 + ($tppRedirectUri == null ? 43 : $tppRedirectUri.hashCode());
        return result;
    }
}

