/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccessType;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentRequestValidator {
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ScaApproachResolver scaApproachResolver;

    public ValidationResult validateRequest(CreateConsentReq request) {
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return new ValidationResult(false, new MessageError(ErrorType.AIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PARAMETER_NOT_SUPPORTED)));
        }
        if (this.isNotSupportedBankOfferedConsent(request)) {
            return new ValidationResult(false, new MessageError(ErrorType.AIS_405, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405)));
        }
        if (!this.isValidExpirationDate(request.getValidUntil())) {
            return new ValidationResult(false, new MessageError(ErrorType.AIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PERIOD_INVALID)));
        }
        if (this.isNotValidFrequencyForRecurringIndicator(request.isRecurringIndicator(), request.getFrequencyPerDay())) {
            return new ValidationResult(false, new MessageError(ErrorType.AIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR)));
        }
        if (this.isNotSupportedAvailableAccounts(request)) {
            return new ValidationResult(false, new MessageError(ErrorType.AIS_405, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405)));
        }
        return new ValidationResult(true, null);
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return this.isConsentGlobal(request) && this.aspspProfileService.getAllPsd2Support() == false;
    }

    private boolean isNotSupportedBankOfferedConsent(CreateConsentReq request) {
        if (this.isNotEmptyAccess(request.getAccess()).booleanValue()) {
            return false;
        }
        if (this.scaApproachResolver.resolveScaApproach() == ScaApproach.EMBEDDED) {
            return true;
        }
        return !this.aspspProfileService.isBankOfferedConsentSupported();
    }

    private boolean isValidExpirationDate(LocalDate validUntil) {
        int consentLifetime = Math.abs(this.aspspProfileService.getConsentLifetime());
        return validUntil.isAfter(LocalDate.now()) && this.isValidConsentLifetime(consentLifetime, validUntil);
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess()) != false && request.getAccess().getAllPsd2() == Xs2aAccountAccessType.ALL_ACCOUNTS;
    }

    private Boolean isNotEmptyAccess(Xs2aAccountAccess access) {
        return Optional.ofNullable(access).map(Xs2aAccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isValidConsentLifetime(int consentLifetime, LocalDate validUntil) {
        return consentLifetime == 0 || validUntil.isBefore(LocalDate.now().plusDays(consentLifetime));
    }

    private boolean isNotValidFrequencyForRecurringIndicator(boolean recurringIndicator, int frequencyPerDay) {
        if (!recurringIndicator) {
            return frequencyPerDay > 1;
        }
        return false;
    }

    private boolean isNotSupportedAvailableAccounts(CreateConsentReq request) {
        if (Objects.isNull((Object)request.getAccess().getAvailableAccounts())) {
            return false;
        }
        return !this.aspspProfileService.isAvailableAccountsConsentSupported();
    }

    @ConstructorProperties(value={"aspspProfileService", "scaApproachResolver"})
    public CreateConsentRequestValidator(AspspProfileServiceWrapper aspspProfileService, ScaApproachResolver scaApproachResolver) {
        this.aspspProfileService = aspspProfileService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

