/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpiPaymentFactory {
    private static final Logger log = LoggerFactory.getLogger(SpiPaymentFactory.class);
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;

    public Optional<? extends SpiPayment> createSpiPaymentByPaymentType(List<PisPayment> pisPayments, String paymentProduct, PaymentType paymentType) {
        switch (paymentType) {
            case SINGLE: {
                return this.createSpiSinglePayment(pisPayments.get(0), paymentProduct);
            }
            case PERIODIC: {
                return this.createSpiPeriodicPayment(pisPayments.get(0), paymentProduct);
            }
            case BULK: {
                return this.createSpiBulkPayment(pisPayments, paymentProduct);
            }
        }
        log.error("Unknown payment type: {}", (Object)paymentType);
        throw new IllegalArgumentException("Unknown payment type");
    }

    public Optional<SpiSinglePayment> createSpiSinglePayment(PisPayment pisPayment, String paymentProduct) {
        SinglePayment singlePayment = this.cmsToXs2aPaymentMapper.mapToSinglePayment(pisPayment);
        if (singlePayment == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment(singlePayment, paymentProduct));
    }

    public Optional<SpiPeriodicPayment> createSpiPeriodicPayment(PisPayment pisPayment, String paymentProduct) {
        PeriodicPayment periodicPayment = this.cmsToXs2aPaymentMapper.mapToPeriodicPayment(pisPayment);
        if (periodicPayment == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodicPayment, paymentProduct));
    }

    public Optional<SpiBulkPayment> createSpiBulkPayment(List<PisPayment> pisPayments, String paymentProduct) {
        BulkPayment bulkPayment = this.cmsToXs2aPaymentMapper.mapToBulkPayment(pisPayments);
        if (bulkPayment == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct));
    }

    @ConstructorProperties(value={"cmsToXs2aPaymentMapper", "xs2aToSpiSinglePaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiBulkPaymentMapper"})
    public SpiPaymentFactory(CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper) {
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
    }
}

