/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="payments")
public class ReadSinglePaymentService
extends ReadPaymentService<PaymentInformationResponse<SinglePayment>> {
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final SinglePaymentSpi singlePaymentSpi;
    private final SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;

    @Override
    public PaymentInformationResponse<SinglePayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        Optional<SpiSinglePayment> spiPaymentOptional = this.spiPaymentFactory.createSpiSinglePayment(pisPayments.get(0), paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<SinglePayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse spiResponse = this.singlePaymentSpi.getPaymentById(spiContextData, spiPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<SinglePayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        SpiSinglePayment spiSinglePayment = (SpiSinglePayment)spiResponse.getPayload();
        SinglePayment xs2aSinglePayment = this.spiToXs2aSinglePaymentMapper.mapToXs2aSinglePayment(spiSinglePayment);
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(aspspConsentData.getConsentId(), xs2aSinglePayment.getTransactionStatus())) {
            return new PaymentInformationResponse<SinglePayment>(ErrorHolder.builder(MessageErrorCode.FORMAT_ERROR).messages(Collections.singletonList("Payment is finalised already, so its status cannot be changed")).build());
        }
        return new PaymentInformationResponse<SinglePayment>(xs2aSinglePayment);
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiContextDataProvider", "updatePaymentStatusAfterSpiService", "singlePaymentSpi", "spiToXs2aSinglePaymentMapper", "spiErrorMapper", "spiPaymentFactory"})
    public ReadSinglePaymentService(PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, SinglePaymentSpi singlePaymentSpi, SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.singlePaymentSpi = singlePaymentSpi;
        this.spiToXs2aSinglePaymentMapper = spiToXs2aSinglePaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
    }
}

