/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="periodic-payments")
public class ReadPeriodicPaymentService
extends ReadPaymentService<PaymentInformationResponse<PeriodicPayment>> {
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;

    @Override
    public PaymentInformationResponse<PeriodicPayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        Optional<SpiPeriodicPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiPeriodicPayment(pisPayments.get(0), paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<PeriodicPayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse spiResponse = this.periodicPaymentSpi.getPaymentById(spiContextData, spiPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<PeriodicPayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        SpiPeriodicPayment spiResponsePayment = (SpiPeriodicPayment)spiResponse.getPayload();
        PeriodicPayment xs2aPeriodicPayment = this.spiToXs2aPeriodicPaymentMapper.mapToXs2aPeriodicPayment(spiResponsePayment);
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(aspspConsentData.getConsentId(), xs2aPeriodicPayment.getTransactionStatus())) {
            return new PaymentInformationResponse<PeriodicPayment>(ErrorHolder.builder(MessageErrorCode.FORMAT_ERROR).messages(Collections.singletonList("Payment is finalised already, so its status cannot be changed")).build());
        }
        return new PaymentInformationResponse<PeriodicPayment>(xs2aPeriodicPayment);
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiContextDataProvider", "updatePaymentStatusAfterSpiService", "periodicPaymentSpi", "spiToXs2aPeriodicPaymentMapper", "spiErrorMapper", "spiPaymentFactory"})
    public ReadPeriodicPaymentService(PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, PeriodicPaymentSpi periodicPaymentSpi, SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.spiToXs2aPeriodicPaymentMapper = spiToXs2aPeriodicPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
    }
}

