/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class ReadCommonPaymentService {
    private final CommonPaymentSpi commonPaymentSpi;
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final SpiToXs2aPaymentInfoMapper spiToXs2aPaymentInfoMapper;

    public PaymentInformationResponse<PisPaymentInfo> getPayment(CommonPayment commonPayment, PsuIdData psuData, AspspConsentData aspspConsentData) {
        SpiPaymentInfo spiPaymentInfo = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse spiResponse = this.commonPaymentSpi.getPaymentById(spiContextData, spiPaymentInfo, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<PisPaymentInfo>(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        SpiPaymentInfo responsePaymentInfo = (SpiPaymentInfo)spiResponse.getPayload();
        return new PaymentInformationResponse<PisPaymentInfo>(this.spiToXs2aPaymentInfoMapper.mapToXs2aPaymentInfo(responsePaymentInfo));
    }

    @ConstructorProperties(value={"commonPaymentSpi", "pisAspspDataService", "spiContextDataProvider", "spiErrorMapper", "xs2aToSpiPaymentInfoMapper", "spiToXs2aPaymentInfoMapper"})
    public ReadCommonPaymentService(CommonPaymentSpi commonPaymentSpi, PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, SpiToXs2aPaymentInfoMapper spiToXs2aPaymentInfoMapper) {
        this.commonPaymentSpi = commonPaymentSpi;
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.spiToXs2aPaymentInfoMapper = spiToXs2aPaymentInfoMapper;
    }
}

