/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="status-bulk-payments")
public class ReadBulkPaymentStatusService
implements ReadPaymentStatusService {
    private final PisAspspDataService pisAspspDataService;
    private final SpiPaymentFactory spiPaymentFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final BulkPaymentSpi bulkPaymentSpi;

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        Optional<SpiBulkPayment> spiBulkPaymentOptional = this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
        if (!spiBulkPaymentOptional.isPresent()) {
            return new ReadPaymentStatusResponse(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiResponse spiResponse = this.bulkPaymentSpi.getPaymentStatusById(spiContextData, spiBulkPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new ReadPaymentStatusResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return new ReadPaymentStatusResponse((TransactionStatus)spiResponse.getPayload());
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiPaymentFactory", "spiErrorMapper", "bulkPaymentSpi"})
    public ReadBulkPaymentStatusService(PisAspspDataService pisAspspDataService, SpiPaymentFactory spiPaymentFactory, SpiErrorMapper spiErrorMapper, BulkPaymentSpi bulkPaymentSpi) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiPaymentFactory = spiPaymentFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.bulkPaymentSpi = bulkPaymentSpi;
    }
}

