/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="bulk-payments")
public class ReadBulkPaymentService
extends ReadPaymentService<PaymentInformationResponse<BulkPayment>> {
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;

    @Override
    public PaymentInformationResponse<BulkPayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        Optional<SpiBulkPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<BulkPayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiResponse spiResponse = this.bulkPaymentSpi.getPaymentById(this.spiContextDataProvider.provideWithPsuIdData(psuData), spiPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<BulkPayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        SpiBulkPayment spiResponsePayment = (SpiBulkPayment)spiResponse.getPayload();
        BulkPayment xs2aBulkPayment = this.spiToXs2aBulkPaymentMapper.mapToXs2aBulkPayment(spiResponsePayment);
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(aspspConsentData.getConsentId(), xs2aBulkPayment.getTransactionStatus())) {
            return new PaymentInformationResponse<BulkPayment>(ErrorHolder.builder(MessageErrorCode.FORMAT_ERROR).messages(Collections.singletonList("Payment is finalised already, so its status cannot be changed")).build());
        }
        return new PaymentInformationResponse<BulkPayment>(xs2aBulkPayment);
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiContextDataProvider", "updatePaymentStatusAfterSpiService", "bulkPaymentSpi", "spiToXs2aBulkPaymentMapper", "spiErrorMapper", "spiPaymentFactory"})
    public ReadBulkPaymentService(PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, BulkPaymentSpi bulkPaymentSpi, SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiToXs2aBulkPaymentMapper = spiToXs2aBulkPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
    }
}

