/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiBulkPaymentMapper {
    private final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;

    public SpiBulkPayment mapToSpiBulkPayment(BulkPayment payment, String paymentProduct) {
        SpiBulkPayment bulk = new SpiBulkPayment();
        bulk.setPaymentId(payment.getPaymentId());
        bulk.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        bulk.setDebtorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        if (payment.getTransactionStatus() != null) {
            bulk.setPaymentStatus(payment.getTransactionStatus());
        }
        bulk.setPaymentProduct(paymentProduct);
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulk.setPayments(this.mapToListSpiSinglePayment(payment.getPayments(), paymentProduct));
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        return bulk;
    }

    private List<SpiSinglePayment> mapToListSpiSinglePayment(List<SinglePayment> payments, String paymentProduct) {
        return payments.stream().map(p -> this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment((SinglePayment)p, paymentProduct)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"xs2aToSpiSinglePaymentMapper", "xs2aToSpiAccountReferenceMapper"})
    public Xs2aToSpiBulkPaymentMapper(Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper) {
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
    }
}

