/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aBulkPaymentMapper {
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    private final SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper;

    public BulkPayment mapToXs2aBulkPayment(@NotNull SpiBulkPayment payment) {
        BulkPayment bulk = new BulkPayment();
        bulk.setPaymentId(payment.getPaymentId());
        bulk.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulk.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getDebtorAccount()).orElse(null));
        bulk.setTransactionStatus(payment.getPaymentStatus());
        bulk.setPayments(this.mapToListXs2aSinglePayments(payment.getPayments()));
        return bulk;
    }

    private List<SinglePayment> mapToListXs2aSinglePayments(List<SpiSinglePayment> payments) {
        return Optional.ofNullable(payments).map(p -> p.stream().map(this.spiToXs2aSinglePaymentMapper::mapToXs2aSinglePayment).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    @ConstructorProperties(value={"spiToXs2aAccountReferenceMapper", "spiToXs2aSinglePaymentMapper"})
    public SpiToXs2aBulkPaymentMapper(SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper, SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper) {
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
        this.spiToXs2aSinglePaymentMapper = spiToXs2aSinglePaymentMapper;
    }
}

