/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error409NGSB;
import de.adorsys.psd2.model.MessageCode409SB;
import de.adorsys.psd2.model.TppMessage409SB;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB409ErrorMapper
extends Psd2ErrorMapper<MessageError, Error409NGSB> {
    @Override
    public Function<MessageError, Error409NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.CONFLICT;
    }

    private Error409NGSB mapToPsd2Error(MessageError messageError) {
        return new Error409NGSB().tppMessages(this.mapToTppMessage409SB(messageError.getTppMessages()));
    }

    private List<TppMessage409SB> mapToTppMessage409SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage409SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode409SB.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

