/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error404NGSB;
import de.adorsys.psd2.model.MessageCode404SB;
import de.adorsys.psd2.model.TppMessage404SB;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB404ErrorMapper
extends Psd2ErrorMapper<MessageError, Error404NGSB> {
    @Override
    public Function<MessageError, Error404NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.NOT_FOUND;
    }

    private Error404NGSB mapToPsd2Error(MessageError messageError) {
        return new Error404NGSB().tppMessages(this.mapToTppMessage404SB(messageError.getTppMessages()));
    }

    private List<TppMessage404SB> mapToTppMessage404SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage404SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode404SB.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

