/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.context;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class SpiContextDataProvider {
    private final TppService tppService;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;

    public SpiContextData provideWithPsuIdData(PsuIdData psuIdData) {
        TppInfo tppInfo = this.tppService.getTppInfo();
        return this.provide(psuIdData, tppInfo);
    }

    public SpiContextData provide(PsuIdData psuIdData, TppInfo tppInfo) {
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuIdData);
        return new SpiContextData(spiPsuData, tppInfo);
    }

    @ConstructorProperties(value={"tppService", "psuDataMapper"})
    public SpiContextDataProvider(TppService tppService, Xs2aToSpiPsuDataMapper psuDataMapper) {
        this.tppService = tppService;
        this.psuDataMapper = psuDataMapper;
    }
}

