/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentService {
    private final AisConsentServiceEncrypted aisConsentService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;

    public String createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CreateAisConsentRequest createAisConsentRequest = this.aisConsentMapper.mapToCreateAisConsentRequest(request, psuData, tppInfo, allowedFrequencyPerDay);
        Optional consent = this.aisConsentService.createConsent(createAisConsentRequest);
        return consent.orElse(null);
    }

    public AccountConsent getAccountConsentById(String consentId) {
        AisAccountConsent aisAccountConsent = this.aisConsentService.getAisAccountConsentById(consentId).orElse(null);
        return this.aisConsentMapper.mapToAccountConsent(aisAccountConsent);
    }

    public AccountConsent getInitialAccountConsentById(String consentId) {
        AisAccountConsent aisAccountConsent = this.aisConsentService.getInitialAisAccountConsentById(consentId).orElse(null);
        return this.aisConsentMapper.mapToAccountConsent(aisAccountConsent);
    }

    public ConsentStatus getAccountConsentStatusById(String consentId) {
        return this.aisConsentService.getConsentStatusById(consentId).orElse(null);
    }

    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        return this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(newConsentId);
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        this.aisConsentService.updateConsentStatusById(consentId, consentStatus);
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus) {
        this.aisConsentService.checkConsentAndSaveActionLog(new AisConsentActionRequest(tppId, consentId, actionStatus));
    }

    public Optional<String> createAisConsentAuthorization(String consentId, ScaStatus scaStatus, PsuIdData psuData) {
        AisConsentAuthorizationRequest request = this.aisConsentAuthorisationMapper.mapToAisConsentAuthorization(scaStatus, psuData);
        return this.aisConsentService.createAuthorization(consentId, request);
    }

    public AccountConsentAuthorization getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        AisConsentAuthorizationResponse response = this.aisConsentService.getAccountConsentAuthorizationById(authorizationId, consentId).orElse(null);
        return this.aisConsentAuthorisationMapper.mapToAccountConsentAuthorization(response);
    }

    public void updateConsentAuthorization(UpdateConsentPsuDataReq updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            String authorizationId = req.getAuthorizationId();
            AisConsentAuthorizationRequest request = this.aisConsentAuthorisationMapper.mapToAisConsentAuthorizationRequest((UpdateConsentPsuDataReq)req);
            this.aisConsentService.updateConsentAuthorization(authorizationId, request);
        });
    }

    public void updateAspspAccountAccess(String consentId, AisAccountAccessInfo aisAccountAccessInfo) {
        this.aisConsentService.updateAspspAccountAccess(consentId, aisAccountAccessInfo);
    }

    public Optional<List<String>> getAuthorisationSubResources(String consentId) {
        return this.aisConsentService.getAuthorisationsByConsentId(consentId);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.aisConsentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.aisConsentService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<Xs2aAuthenticationObject> methods) {
        return this.aisConsentService.saveAuthenticationMethods(authorisationId, this.xs2AAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentMapper", "aisConsentAuthorisationMapper", "xs2AAuthenticationObjectToCmsScaMethodMapper", "frequencyPerDateCalculationService"})
    public Xs2aAisConsentService(AisConsentServiceEncrypted aisConsentService, Xs2aAisConsentMapper aisConsentMapper, Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService) {
        this.aisConsentService = aisConsentService;
        this.aisConsentMapper = aisConsentMapper;
        this.aisConsentAuthorisationMapper = aisConsentAuthorisationMapper;
        this.xs2AAuthenticationObjectToCmsScaMethodMapper = xs2AAuthenticationObjectToCmsScaMethodMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
    }
}

