/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis.stage;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public abstract class PisScaStage<T, U, R>
implements BiFunction<T, U, R> {
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final ApplicationContext applicationContext;

    protected PaymentSpi getPaymentService(GetPisAuthorisationResponse pisAuthorisationResponse, PaymentType paymentType) {
        if (CollectionUtils.isEmpty((Collection)pisAuthorisationResponse.getPayments())) {
            return (PaymentSpi)this.applicationContext.getBean(CommonPaymentSpi.class);
        }
        if (PaymentType.SINGLE == paymentType) {
            return (PaymentSpi)this.applicationContext.getBean(SinglePaymentSpi.class);
        }
        if (PaymentType.PERIODIC == paymentType) {
            return (PaymentSpi)this.applicationContext.getBean(PeriodicPaymentSpi.class);
        }
        return (PaymentSpi)this.applicationContext.getBean(BulkPaymentSpi.class);
    }

    protected SpiPayment mapToSpiPayment(GetPisAuthorisationResponse pisAuthorisationResponse, PaymentType paymentType, String paymentProduct) {
        if (CollectionUtils.isEmpty((Collection)pisAuthorisationResponse.getPayments())) {
            return this.mapToSpiPayment(pisAuthorisationResponse.getPaymentInfo());
        }
        return this.mapToSpiPayment(pisAuthorisationResponse.getPayments(), paymentType, paymentProduct);
    }

    private SpiPayment mapToSpiPayment(List<PisPayment> payments, PaymentType paymentType, String paymentProduct) {
        if (PaymentType.SINGLE == paymentType) {
            SinglePayment singlePayment = this.cmsToXs2aPaymentMapper.mapToSinglePayment(payments.get(0));
            return this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment(singlePayment, paymentProduct);
        }
        if (PaymentType.PERIODIC == paymentType) {
            PeriodicPayment periodicPayment = this.cmsToXs2aPaymentMapper.mapToPeriodicPayment(payments.get(0));
            return this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodicPayment, paymentProduct);
        }
        BulkPayment bulkPayment = this.cmsToXs2aPaymentMapper.mapToBulkPayment(payments);
        return this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct);
    }

    private SpiPayment mapToSpiPayment(PisPaymentInfo paymentInfo) {
        SpiPaymentInfo spiPaymentInfo = new SpiPaymentInfo(paymentInfo.getPaymentProduct());
        spiPaymentInfo.setPaymentId(paymentInfo.getPaymentId());
        spiPaymentInfo.setPaymentType(paymentInfo.getPaymentType());
        spiPaymentInfo.setStatus(paymentInfo.getTransactionStatus());
        spiPaymentInfo.setPaymentData(paymentInfo.getPaymentData());
        return spiPaymentInfo;
    }

    protected PsuIdData extractPsuIdData(Xs2aUpdatePisCommonPaymentPsuDataRequest request, boolean paymentCancellation) {
        PsuIdData psuDataInRequest = request.getPsuData();
        if (this.isPsuExist(psuDataInRequest)) {
            return psuDataInRequest;
        }
        return this.getGetPisAuthorisationResponse(request.getAuthorisationId(), paymentCancellation).map(GetPisAuthorisationResponse::getPsuId).filter(StringUtils::isNotBlank).map(id -> new PsuIdData(id, null, null, null)).orElse(psuDataInRequest);
    }

    protected boolean isPsuExist(PsuIdData psuIdData) {
        return Optional.ofNullable(psuIdData).map(PsuIdData::isNotEmpty).orElse(false);
    }

    private Optional<GetPisAuthorisationResponse> getGetPisAuthorisationResponse(String authorisationId, boolean paymentCancellation) {
        return paymentCancellation ? this.pisCommonPaymentServiceEncrypted.getPisCancellationAuthorisationById(authorisationId) : this.pisCommonPaymentServiceEncrypted.getPisAuthorisationById(authorisationId);
    }

    @ConstructorProperties(value={"cmsToXs2aPaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiSinglePaymentMapper", "xs2aToSpiBulkPaymentMapper", "pisCommonPaymentServiceEncrypted", "applicationContext"})
    public PisScaStage(CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, ApplicationContext applicationContext) {
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.applicationContext = applicationContext;
    }
}

