/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.ScaApproachHolder;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ScaApproachResolver {
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;
    private final ScaApproachHolder scaApproachHolder;

    public ScaApproach resolveScaApproach() {
        if (this.scaApproachHolder.isNotEmpty()) {
            return this.scaApproachHolder.getScaApproach();
        }
        boolean tppRedirectPreferred = this.requestProviderService.resolveTppRedirectPreferred();
        List scaApproaches = this.aspspProfileService.getScaApproaches();
        if (tppRedirectPreferred && scaApproaches.contains(ScaApproach.REDIRECT)) {
            return ScaApproach.REDIRECT;
        }
        return this.getFirst(scaApproaches);
    }

    public void forceDecoupledScaApproach() {
        this.scaApproachHolder.setScaApproach(ScaApproach.DECOUPLED);
    }

    private ScaApproach getFirst(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(0);
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService", "scaApproachHolder"})
    public ScaApproachResolver(AspspProfileService aspspProfileService, RequestProviderService requestProviderService, ScaApproachHolder scaApproachHolder) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
        this.scaApproachHolder = scaApproachHolder;
    }
}

