/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentFactory;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentStatusFactory;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.payment.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateBulkPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePeriodicPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateSinglePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadCommonPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final ReadPaymentFactory readPaymentFactory;
    private final ReadPaymentStatusFactory readPaymentStatusFactory;
    private final SpiPaymentFactory spiPaymentFactory;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final PisAspspDataService pisAspspDataService;
    private final PisPsuDataService pisPsuDataService;
    private final TppService tppService;
    private final CreateSinglePaymentService createSinglePaymentService;
    private final CreatePeriodicPaymentService createPeriodicPaymentService;
    private final CreateBulkPaymentService createBulkPaymentService;
    private final CommonPaymentSpi commonPaymentSpi;
    private final AspspProfileServiceWrapper profileService;
    private final CancelPaymentService cancelPaymentService;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aEventService xs2aEventService;
    private final CreateCommonPaymentService createCommonPaymentService;
    private final ReadCommonPaymentService readCommonPaymentService;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final ReadCommonPaymentStatusService readCommonPaymentStatusService;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private static final String MESSAGE_ERROR_NO_PSU = "Please provide the PSU identification data";

    public ResponseObject createPayment(Object payment, PaymentInitiationParameters paymentInitiationParameters) {
        this.xs2aEventService.recordTppRequest(EventType.PAYMENT_INITIATION_REQUEST_RECEIVED, payment);
        if (this.profileService.isPsuInInitialRequestMandated() && paymentInitiationParameters.getPsuData().isEmpty()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR, MESSAGE_ERROR_NO_PSU))).build();
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(paymentInitiationParameters.getTppRedirectUri());
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentInitiationParameters.getPaymentProduct())) {
            CommonPayment request = new CommonPayment();
            request.setPaymentType(paymentInitiationParameters.getPaymentType());
            request.setPaymentProduct(paymentInitiationParameters.getPaymentProduct());
            request.setPaymentData((byte[])payment);
            request.setTppInfo(tppInfo);
            request.setPsuDataList(Collections.singletonList(paymentInitiationParameters.getPsuData()));
            return this.createCommonPaymentService.createPayment(request, paymentInitiationParameters, tppInfo);
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.createSinglePaymentService.createPayment((SinglePayment)payment, paymentInitiationParameters, tppInfo);
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.createPeriodicPaymentService.createPayment((PeriodicPayment)payment, paymentInitiationParameters, tppInfo);
        }
        return this.createBulkPaymentService.createPayment((BulkPayment)payment, paymentInitiationParameters, tppInfo);
    }

    public ResponseObject getPaymentById(PaymentType paymentType, String paymentProduct, String paymentId) {
        PaymentInformationResponse response;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"))).build();
        }
        PisCommonPaymentResponse commonPaymentResponse = pisCommonPaymentOptional.get();
        if (this.isPaymentTypeIncorrect(paymentType, commonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_405, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405, "Service invalid for adressed payment"))).build();
        }
        if (this.isPaymentProductIncorrect(paymentProduct, commonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_403, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PRODUCT_INVALID, "Payment product invalid for addressed payment"))).build();
        }
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(commonPaymentResponse);
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(paymentId);
        if (commonPayment.getPaymentData() != null) {
            response = this.readCommonPaymentService.getPayment(commonPayment, this.readPsuIdDataFromList(commonPayment.getPsuDataList()), aspspConsentData);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(commonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR, "Payment not found"))).build();
            }
            ReadPaymentService readPaymentService = (ReadPaymentService)this.readPaymentFactory.getService(paymentType.getValue());
            response = (PaymentInformationResponse)readPaymentService.getPayment(pisPayments, commonPaymentResponse.getPaymentProduct(), this.readPsuIdDataFromList(commonPayment.getPsuDataList()), aspspConsentData);
        }
        if (response.hasError()) {
            ErrorHolder errorHolder = response.getErrorHolder();
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        return ResponseObject.builder().body(response.getPayment()).build();
    }

    public ResponseObject<TransactionStatus> getPaymentStatusById(PaymentType paymentType, String paymentProduct, String paymentId) {
        ReadPaymentStatusResponse readPaymentStatusResponse;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_TRANSACTION_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"))).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        if (this.isPaymentTypeIncorrect(paymentType, pisCommonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_405, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405, "Service invalid for adressed payment"))).build();
        }
        if (this.isPaymentProductIncorrect(paymentProduct, pisCommonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_403, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PRODUCT_INVALID, "Payment product invalid for addressed payment"))).build();
        }
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().body(TransactionStatus.RJCT).build();
        }
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(paymentId);
        List<PsuIdData> psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(this.readPsuIdDataFromList(psuData));
        if (pisCommonPaymentResponse.getPaymentData() != null) {
            readPaymentStatusResponse = this.readCommonPaymentStatusService.readPaymentStatus(pisCommonPaymentResponse, spiContextData, aspspConsentData);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR, "Payment not found"))).build();
            }
            ReadPaymentStatusService readPaymentStatusService = (ReadPaymentStatusService)this.readPaymentStatusFactory.getService("status-" + paymentType.getValue());
            readPaymentStatusResponse = readPaymentStatusService.readPaymentStatus(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), spiContextData, aspspConsentData);
        }
        if (readPaymentStatusResponse.hasError()) {
            ErrorHolder errorHolder = readPaymentStatusResponse.getErrorHolder();
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        TransactionStatus transactionStatus = readPaymentStatusResponse.getStatus();
        if (transactionStatus == null) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_403, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_403))).build();
        }
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(paymentId, transactionStatus)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR, "Payment is finalised already, so its status cannot be changed"))).build();
        }
        return ResponseObject.builder().body(transactionStatus).build();
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        Object commonPayment;
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.PAYMENT_CANCELLATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"))).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        if (this.isPaymentTypeIncorrect(paymentType, pisCommonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_405, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405, "Service invalid for addressed payment"))).build();
        }
        if (this.isPaymentProductIncorrect(paymentProduct, pisCommonPaymentResponse)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_403, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PRODUCT_INVALID, "Payment product invalid for addressed payment"))).build();
        }
        SpiPaymentInfo spiPayment = null;
        if (pisCommonPaymentResponse.getPaymentData() != null) {
            commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
            spiPayment = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo((CommonPayment)commonPayment);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"))).build();
            }
            Optional<? extends SpiPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiPaymentByPaymentType(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), paymentType);
            if (!spiPaymentOptional.isPresent()) {
                log.error("Unknown payment type: {}", (Object)paymentType);
                return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
            }
            spiPayment = spiPaymentOptional.get();
        }
        commonPayment = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (((Optional)commonPayment).isPresent() && this.isFinalisedPayment((PisCommonPaymentResponse)((Optional)commonPayment).get())) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.PIS_400, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR, "Payment is finalised already and cannot be cancelled"))).build();
        }
        List<PsuIdData> psuData = this.pisPsuDataService.getPsuDataByPaymentId(encryptedPaymentId);
        if (this.profileService.isPaymentCancellationAuthorizationMandated()) {
            return this.cancelPaymentService.initiatePaymentCancellation(this.readPsuIdDataFromList(psuData), (SpiPayment)spiPayment, encryptedPaymentId);
        }
        return this.cancelPaymentService.cancelPaymentWithoutAuthorisation(this.readPsuIdDataFromList(psuData), (SpiPayment)spiPayment, encryptedPaymentId);
    }

    private boolean isPaymentTypeIncorrect(PaymentType paymentType, PisCommonPaymentResponse commonPaymentResponse) {
        return commonPaymentResponse.getPaymentType() != paymentType;
    }

    private boolean isPaymentProductIncorrect(String paymentProduct, PisCommonPaymentResponse commonPaymentResponse) {
        return !commonPaymentResponse.getPaymentProduct().equalsIgnoreCase(paymentProduct);
    }

    private boolean isFinalisedPayment(PisCommonPaymentResponse response) {
        List finalisedPayments = response.getPayments().stream().filter(p -> p.getTransactionStatus().isFinalisedStatus()).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(finalisedPayments);
    }

    private List<PisPayment> getPisPaymentFromCommonPaymentResponse(PisCommonPaymentResponse pisCommonPaymentResponse) {
        List<PisPayment> pisPayments = Optional.of(pisCommonPaymentResponse).map(PisCommonPaymentResponse::getPayments).orElse(Collections.emptyList());
        pisPayments.forEach(pmt -> pmt.setPaymentId(pisCommonPaymentResponse.getExternalId()));
        return pisPayments;
    }

    private PsuIdData readPsuIdDataFromList(List<PsuIdData> psuIdDataList) {
        if (CollectionUtils.isNotEmpty(psuIdDataList)) {
            return psuIdDataList.get(0);
        }
        return null;
    }

    @ConstructorProperties(value={"readPaymentFactory", "readPaymentStatusFactory", "spiPaymentFactory", "pisCommonPaymentService", "updatePaymentStatusAfterSpiService", "pisAspspDataService", "pisPsuDataService", "tppService", "createSinglePaymentService", "createPeriodicPaymentService", "createBulkPaymentService", "commonPaymentSpi", "profileService", "cancelPaymentService", "spiErrorMapper", "xs2aEventService", "createCommonPaymentService", "readCommonPaymentService", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "spiContextDataProvider", "readCommonPaymentStatusService", "standardPaymentProductsResolver"})
    public PaymentService(ReadPaymentFactory readPaymentFactory, ReadPaymentStatusFactory readPaymentStatusFactory, SpiPaymentFactory spiPaymentFactory, Xs2aPisCommonPaymentService pisCommonPaymentService, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, PisAspspDataService pisAspspDataService, PisPsuDataService pisPsuDataService, TppService tppService, CreateSinglePaymentService createSinglePaymentService, CreatePeriodicPaymentService createPeriodicPaymentService, CreateBulkPaymentService createBulkPaymentService, CommonPaymentSpi commonPaymentSpi, AspspProfileServiceWrapper profileService, CancelPaymentService cancelPaymentService, SpiErrorMapper spiErrorMapper, Xs2aEventService xs2aEventService, CreateCommonPaymentService createCommonPaymentService, ReadCommonPaymentService readCommonPaymentService, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider, ReadCommonPaymentStatusService readCommonPaymentStatusService, StandardPaymentProductsResolver standardPaymentProductsResolver) {
        this.readPaymentFactory = readPaymentFactory;
        this.readPaymentStatusFactory = readPaymentStatusFactory;
        this.spiPaymentFactory = spiPaymentFactory;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.pisAspspDataService = pisAspspDataService;
        this.pisPsuDataService = pisPsuDataService;
        this.tppService = tppService;
        this.createSinglePaymentService = createSinglePaymentService;
        this.createPeriodicPaymentService = createPeriodicPaymentService;
        this.createBulkPaymentService = createBulkPaymentService;
        this.commonPaymentSpi = commonPaymentSpi;
        this.profileService = profileService;
        this.cancelPaymentService = cancelPaymentService;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aEventService = xs2aEventService;
        this.createCommonPaymentService = createCommonPaymentService;
        this.readCommonPaymentService = readCommonPaymentService;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.readCommonPaymentStatusService = readCommonPaymentStatusService;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
    }
}

