/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aBookingStatus;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ConsentService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountDetailsMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceReportMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiTransactionListToXs2aAccountReportMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    private final AccountSpi accountSpi;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;
    private final SpiToXs2aAccountDetailsMapper accountDetailsMapper;
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aBalanceReportMapper balanceReportMapper;
    private final SpiToXs2aAccountReferenceMapper referenceMapper;
    private final SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper;
    private final SpiToXs2aTransactionMapper spiToXs2aTransactionMapper;
    private final ValueValidatorService validatorService;
    private final ConsentService consentService;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final AisConsentDataService aisConsentDataService;
    private final Xs2aEventService xs2aEventService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;

    public ResponseObject<Map<String, List<Xs2aAccountDetails>>> getAccountList(String consentId, boolean withBalance) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_LIST_REQUEST_RECEIVED);
        ResponseObject<AccountConsent> accountConsentResponse = this.consentService.getValidatedConsent(consentId, withBalance);
        if (accountConsentResponse.hasError()) {
            return ResponseObject.builder().fail(accountConsentResponse.getError()).build();
        }
        AccountConsent accountConsent = accountConsentResponse.getBody();
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
        SpiResponse spiResponse = this.accountSpi.requestAccountList(contextData, withBalance, this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        List<Xs2aAccountDetails> accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetailsList((List)spiResponse.getPayload());
        this.accountReferenceUpdater.updateAccountReferences(consentId, accountDetails);
        ResponseObject<Map<String, List<Xs2aAccountDetails>>> response = ResponseObject.builder().body(Collections.singletonMap("accountList", accountDetails)).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(withBalance, TypeAccess.ACCOUNT, response));
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
        return response;
    }

    public ResponseObject<Xs2aAccountDetails> getAccountDetails(String consentId, String accountId, boolean withBalance) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_DETAILS_REQUEST_RECEIVED);
        ResponseObject<AccountConsent> accountConsentResponse = this.consentService.getValidatedConsent(consentId, withBalance);
        if (accountConsentResponse.hasError()) {
            return ResponseObject.builder().fail(accountConsentResponse.getError()).build();
        }
        AccountConsent accountConsent = accountConsentResponse.getBody();
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getAccounts(), accountId);
        if (this.isNotPermittedAccountReference(requestedAccountReference, accountConsent.getAccess(), withBalance)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
        SpiResponse spiResponse = this.accountSpi.requestAccountDetailForAccount(contextData, withBalance, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        SpiAccountDetails spiAccountDetails = (SpiAccountDetails)spiResponse.getPayload();
        if (spiAccountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        Xs2aAccountDetails accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetails(spiAccountDetails);
        ResponseObject<Xs2aAccountDetails> response = ResponseObject.builder().body(accountDetails).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(withBalance, TypeAccess.ACCOUNT, response));
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
        return response;
    }

    public ResponseObject<Xs2aBalancesReport> getBalancesReport(String consentId, String accountId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_BALANCE_REQUEST_RECEIVED);
        ResponseObject<AccountConsent> accountConsentResponse = this.consentService.getValidatedConsent(consentId);
        if (accountConsentResponse.hasError()) {
            return ResponseObject.builder().fail(accountConsentResponse.getError()).build();
        }
        AccountConsent accountConsent = accountConsentResponse.getBody();
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getBalances(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
        SpiResponse spiResponse = this.accountSpi.requestBalancesForAccount(contextData, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        if (spiResponse.getPayload() == null) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        Xs2aBalancesReport balancesReport = this.balanceReportMapper.mapToXs2aBalancesReport((List)spiResponse.getPayload(), requestedAccountReference.get());
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(false, TypeAccess.BALANCE, response));
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
        return response;
    }

    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(String consentId, String accountId, String acceptHeader, boolean withBalance, LocalDate dateFrom, LocalDate dateTo, Xs2aBookingStatus bookingStatus) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_LIST_REQUEST_RECEIVED);
        ResponseObject<AccountConsent> accountConsentResponse = this.consentService.getValidatedConsent(consentId, withBalance);
        if (accountConsentResponse.hasError()) {
            return ResponseObject.builder().fail(accountConsentResponse.getError()).build();
        }
        AccountConsent accountConsent = accountConsentResponse.getBody();
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getTransactions(), accountId);
        if (this.isNotPermittedAccountReference(requestedAccountReference, accountConsent.getAccess(), withBalance)) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        LocalDate dateToChecked = Optional.ofNullable(dateTo).orElseGet(LocalDate::now);
        this.validatorService.validateAccountIdPeriod(accountId, dateFrom, dateToChecked);
        boolean isTransactionsShouldContainBalances = !this.aspspProfileService.isTransactionsWithoutBalancesSupported() || withBalance;
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
        SpiResponse spiResponse = this.accountSpi.requestTransactionsForAccount(contextData, acceptHeader, isTransactionsShouldContainBalances, dateFrom, dateToChecked, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            if (spiResponse.getResponseStatus() == SpiResponseStatus.NOT_SUPPORTED) {
                return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_406, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.REQUESTED_FORMATS_INVALID))).build();
            }
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        SpiTransactionReport spiTransactionReport = (SpiTransactionReport)spiResponse.getPayload();
        if (spiTransactionReport == null) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        Optional<Xs2aAccountReport> report = this.transactionsToAccountReportMapper.mapToXs2aAccountReport(spiTransactionReport.getTransactions(), spiTransactionReport.getTransactionsRaw()).map(r -> this.filterByBookingStatus((Xs2aAccountReport)r, bookingStatus));
        Xs2aTransactionsReport transactionsReport = new Xs2aTransactionsReport();
        transactionsReport.setAccountReport(report.orElseGet(() -> new Xs2aAccountReport(Collections.emptyList(), Collections.emptyList(), null)));
        transactionsReport.setAccountReference(this.referenceMapper.mapToXs2aAccountReference(requestedAccountReference.get()).orElse(null));
        transactionsReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(spiTransactionReport.getBalances()));
        transactionsReport.setResponseContentType(spiTransactionReport.getResponseContentType());
        ResponseObject<Xs2aTransactionsReport> response = ResponseObject.builder().body(transactionsReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.createActionStatus(withBalance, TypeAccess.TRANSACTION, response));
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
        return response;
    }

    public ResponseObject<Transactions> getTransactionDetails(String consentId, String accountId, String transactionId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_DETAILS_REQUEST_RECEIVED);
        ResponseObject<AccountConsent> accountConsentResponse = this.consentService.getValidatedConsent(consentId);
        if (accountConsentResponse.hasError()) {
            return ResponseObject.builder().fail(accountConsentResponse.getError()).build();
        }
        AccountConsent accountConsent = accountConsentResponse.getBody();
        Optional<SpiAccountReference> requestedAccountReference = this.findAccountReference(accountConsent.getAccess().getTransactions(), accountId);
        if (!requestedAccountReference.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        this.validatorService.validateAccountIdTransactionId(accountId, transactionId);
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
        SpiResponse spiResponse = this.accountSpi.requestTransactionForAccountByTransactionId(contextData, transactionId, requestedAccountReference.get(), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        SpiTransaction payload = (SpiTransaction)spiResponse.getPayload();
        if (payload == null) {
            return ResponseObject.builder().fail(new MessageError(ErrorType.AIS_404, new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        Transactions transactions = this.spiToXs2aTransactionMapper.mapToXs2aTransaction(payload);
        this.checkAndExpireConsentIfOneAccessType(accountConsent, consentId);
        return ResponseObject.builder().body(transactions).build();
    }

    private ActionStatus createActionStatus(boolean withBalance, TypeAccess access, ResponseObject response) {
        return response.hasError() ? this.consentMapper.mapActionStatusError(response.getError().getTppMessage().getMessageErrorCode(), withBalance, access) : ActionStatus.SUCCESS;
    }

    private Xs2aAccountReport filterByBookingStatus(Xs2aAccountReport report, Xs2aBookingStatus bookingStatus) {
        return new Xs2aAccountReport(EnumSet.of(Xs2aBookingStatus.BOOKED, Xs2aBookingStatus.BOTH).contains((Object)bookingStatus) ? report.getBooked() : Collections.emptyList(), EnumSet.of(Xs2aBookingStatus.PENDING, Xs2aBookingStatus.BOTH).contains((Object)bookingStatus) ? report.getPending() : Collections.emptyList(), report.getTransactionsRaw());
    }

    private boolean isNotPermittedAccountReference(Optional<SpiAccountReference> requestedAccountReference, Xs2aAccountAccess consentAccountAccess, boolean withBalance) {
        return requestedAccountReference.map(accountReference -> {
            List<AccountReference> accountReferences = withBalance ? consentAccountAccess.getBalances() : consentAccountAccess.getAccounts();
            return !this.consentService.isValidAccountByAccess(accountReference.getResourceId(), accountReferences);
        }).orElse(true);
    }

    private Optional<SpiAccountReference> findAccountReference(List<AccountReference> references, String resourceId) {
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().map(this.xs2aToSpiAccountReferenceMapper::mapToSpiAccountReference);
    }

    private void checkAndExpireConsentIfOneAccessType(AccountConsent accountConsent, String encryptedConsentId) {
        if (accountConsent.isOneAccessType()) {
            this.aisConsentService.updateConsentStatus(encryptedConsentId, ConsentStatus.EXPIRED);
        }
    }

    @ConstructorProperties(value={"accountSpi", "xs2aToSpiAccountReferenceMapper", "accountDetailsMapper", "balanceMapper", "balanceReportMapper", "referenceMapper", "transactionsToAccountReportMapper", "spiToXs2aTransactionMapper", "validatorService", "consentService", "aisConsentService", "consentMapper", "tppService", "aspspProfileService", "aisConsentDataService", "xs2aEventService", "spiContextDataProvider", "accountReferenceUpdater", "spiErrorMapper"})
    public AccountService(AccountSpi accountSpi, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper, SpiToXs2aAccountDetailsMapper accountDetailsMapper, SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aBalanceReportMapper balanceReportMapper, SpiToXs2aAccountReferenceMapper referenceMapper, SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper, SpiToXs2aTransactionMapper spiToXs2aTransactionMapper, ValueValidatorService validatorService, ConsentService consentService, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, AspspProfileServiceWrapper aspspProfileService, AisConsentDataService aisConsentDataService, Xs2aEventService xs2aEventService, SpiContextDataProvider spiContextDataProvider, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper) {
        this.accountSpi = accountSpi;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
        this.accountDetailsMapper = accountDetailsMapper;
        this.balanceMapper = balanceMapper;
        this.balanceReportMapper = balanceReportMapper;
        this.referenceMapper = referenceMapper;
        this.transactionsToAccountReportMapper = transactionsToAccountReportMapper;
        this.spiToXs2aTransactionMapper = spiToXs2aTransactionMapper;
        this.validatorService = validatorService;
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentDataService = aisConsentDataService;
        this.xs2aEventService = xs2aEventService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
    }
}

