/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationMapper {
    private final CoreObjectsMapper coreObjectsMapper;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final RedirectLinkBuilder redirectLinkBuilder;

    public StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse createConsentAuthorizationResponse) {
        return Optional.ofNullable(createConsentAuthorizationResponse).map(csar -> {
            boolean redirectApproachUsed = this.aspspProfileService.getScaApproach() == ScaApproach.REDIRECT;
            String link = redirectApproachUsed ? this.redirectLinkBuilder.buildConsentScaRedirectLink(csar.getConsentId(), csar.getAuthorizationId()) : ControllerLinkBuilder.linkTo((Object)((ConsentApi)ControllerLinkBuilder.methodOn(ConsentApi.class, (Object[])new Object[0]))._updateConsentsPsuData(null, csar.getConsentId(), csar.getAuthorizationId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).toString();
            return new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(createConsentAuthorizationResponse.getScaStatus()))._links(Collections.singletonMap(csar.getResponseLinkType().getValue(), link));
        }).orElse(null);
    }

    @NotNull
    public ScaStatusResponse mapToScaStatusResponse(@NotNull ScaStatus scaStatus) {
        return new ScaStatusResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(scaStatus));
    }

    @ConstructorProperties(value={"coreObjectsMapper", "aspspProfileService", "redirectLinkBuilder"})
    public AuthorisationMapper(CoreObjectsMapper coreObjectsMapper, AspspProfileServiceWrapper aspspProfileService, RedirectLinkBuilder redirectLinkBuilder) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.aspspProfileService = aspspProfileService;
        this.redirectLinkBuilder = redirectLinkBuilder;
    }
}

