/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.tpp;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.model.MessageCode401PIS;
import de.adorsys.psd2.model.TppMessage401PIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppUniqueParamsHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TppStopListInterceptor
extends HandlerInterceptorAdapter {
    private static final String STOP_LIST_ERROR_MESSAGE = "Signature/corporate seal certificate has been blocked by the ASPSP";
    private final TppService tppService;
    private final TppStopListService tppStopListService;
    private final ObjectMapper objectMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        TppInfo tppInfo = this.tppService.getTppInfo();
        if (this.tppStopListService.checkIfTppBlocked(new TppUniqueParamsHolder(tppInfo.getAuthorisationNumber(), tppInfo.getAuthorityId()))) {
            response.getWriter().write(this.objectMapper.writeValueAsString((Object)this.buildErrorTppMessages()));
            response.setContentType("application/json");
            response.setStatus(MessageErrorCode.CERTIFICATE_BLOCKED.getCode());
            return false;
        }
        return true;
    }

    private TppMessage401PIS buildErrorTppMessages() {
        TppMessage401PIS tppMessage = new TppMessage401PIS();
        tppMessage.setCategory(TppMessageCategory.ERROR);
        tppMessage.setCode(MessageCode401PIS.CERTIFICATE_BLOCKED);
        tppMessage.setText(STOP_LIST_ERROR_MESSAGE);
        return tppMessage;
    }

    @ConstructorProperties(value={"tppService", "tppStopListService", "objectMapper"})
    public TppStopListInterceptor(TppService tppService, TppStopListService tppStopListService, ObjectMapper objectMapper) {
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
        this.objectMapper = objectMapper;
    }
}

