/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.signature.TppSignatureValidator;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignatureFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    private final AspspProfileServiceWrapper aspspProfileService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String signature = request.getHeader("signature");
        if (StringUtils.isBlank((CharSequence)signature)) {
            response.sendError(401, CertificateErrorMsgCode.SIGNATURE_MISSING.toString());
            return;
        }
        if (this.digestContainsErrors(request)) {
            response.sendError(400, CertificateErrorMsgCode.FORMAT_ERROR.toString());
            return;
        }
        Map<String, String> headers = this.obtainRequestHeaders(request);
        String encodedTppCert = request.getHeader("tpp-signature-certificate");
        TppSignatureValidator tppSignatureValidator = new TppSignatureValidator();
        try {
            if (tppSignatureValidator.verifySignature(signature, encodedTppCert, headers)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(401, CertificateErrorMsgCode.SIGNATURE_INVALID.toString());
            }
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            log.debug(e.getMessage());
            response.sendError(401, CertificateErrorMsgCode.SIGNATURE_INVALID.toString());
        }
    }

    private boolean digestContainsErrors(HttpServletRequest httpRequest) {
        String digest = httpRequest.getHeader("digest");
        return StringUtils.isBlank((CharSequence)digest) || !Arrays.asList(64, 128).contains(digest.getBytes().length);
    }

    private Map<String, String> obtainRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public SignatureFilter(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

