/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.PaymentApi;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse204202;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperPsd2;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperXs2a;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the payment initiation", tags={"Payment Initiation Service (PIS)"})
public class PaymentController
implements PaymentApi {
    private final PaymentService xs2aPaymentService;
    private final ResponseMapper responseMapper;
    private final PaymentModelMapperPsd2 paymentModelMapperPsd2;
    private final PaymentModelMapperXs2a paymentModelMapperXs2a;
    private final ConsentModelMapper consentModelMapper;
    private final PaymentAuthorisationService paymentAuthorisationService;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;
    private final AuthorisationMapper authorisationMapper;

    public ResponseEntity getPaymentInitiationStatus(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject response = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentStatusById((PaymentType)pt, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        return this.responseMapper.ok(response, PaymentModelMapperPsd2::mapToStatusResponse12);
    }

    public ResponseEntity getPaymentInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject response = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentById((PaymentType)pt, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        return response.hasError() ? this.responseMapper.ok(response) : this.responseMapper.ok(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToGetPaymentResponse12(response.getBody(), (PaymentType)PaymentType.getByValue((String)paymentService).get(), "sepa-credit-transfers")).build());
    }

    public ResponseEntity initiatePayment(Object body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, String tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, boolean tpPExplicitAuthorisationPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aPayment(body, paymentInitiationParameters), paymentInitiationParameters);
        return serviceResponse.hasError() ? this.responseMapper.created(serviceResponse) : this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse12(serviceResponse.getBody())).build());
    }

    public ResponseEntity<Object> initiatePayment(UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String xmlSct, String jsonStandingorderType, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, String tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, boolean tpPExplicitAuthorisationPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aXmlPayment(paymentInitiationParameters, xmlSct, jsonStandingorderType), paymentInitiationParameters);
        return serviceResponse.hasError() ? this.responseMapper.created(serviceResponse) : this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse12(serviceResponse.getBody())).build());
    }

    public ResponseEntity cancelPayment(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject serviceResponse = PaymentType.getByValue((String)paymentService).map(type -> this.xs2aPaymentService.cancelPayment((PaymentType)type, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        if (serviceResponse.hasError()) {
            return this.responseMapper.ok(serviceResponse);
        }
        CancelPaymentResponse cancelPayment = (CancelPaymentResponse)serviceResponse.getBody();
        PaymentInitiationCancelResponse204202 response = this.paymentModelMapperPsd2.mapToPaymentInitiationCancelResponse(cancelPayment);
        return cancelPayment.isStartAuthorisationRequired() ? this.responseMapper.accepted(ResponseObject.builder().body(response).build()) : this.responseMapper.ok(ResponseObject.builder().body(response).build());
    }

    public ResponseEntity getPaymentCancellationScaStatus(String paymentService, String paymentProduct, String paymentId, String cancellationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.paymentCancellationAuthorisationService.getPaymentCancellationAuthorisationScaStatus(paymentId, cancellationId), this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.paymentAuthorisationService.getPaymentInitiationAuthorisations(paymentId), this.consentModelMapper::mapToAuthorisations);
    }

    public ResponseEntity getPaymentInitiationCancellationAuthorisationInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.paymentCancellationAuthorisationService.getPaymentInitiationCancellationAuthorisationInformation(paymentId));
    }

    public ResponseEntity getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.paymentAuthorisationService.getPaymentInitiationAuthorisationScaStatus(paymentId, authorisationId), this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity startPaymentAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.responseMapper.created(this.paymentAuthorisationService.createPisAuthorization(paymentId, (PaymentType)PaymentType.getByValue((String)paymentService).get(), psuData), this.consentModelMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity startPaymentInitiationCancellationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.responseMapper.created(this.paymentCancellationAuthorisationService.createPisCancellationAuthorization(paymentId, psuData, (PaymentType)PaymentType.getByValue((String)paymentService).get()), this.consentModelMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity updatePaymentCancellationPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String cancellationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> response = this.paymentCancellationAuthorisationService.updatePisCancellationPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, cancellationId, paymentService, (Map)body));
        return this.responseMapper.ok(response, this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    public ResponseEntity updatePaymentPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.responseMapper.ok(this.paymentAuthorisationService.updatePisCommonPaymentPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, authorisationId, paymentService, (Map)body)), this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    @ConstructorProperties(value={"xs2aPaymentService", "responseMapper", "paymentModelMapperPsd2", "paymentModelMapperXs2a", "consentModelMapper", "paymentAuthorisationService", "paymentCancellationAuthorisationService", "authorisationMapper"})
    public PaymentController(PaymentService xs2aPaymentService, ResponseMapper responseMapper, PaymentModelMapperPsd2 paymentModelMapperPsd2, PaymentModelMapperXs2a paymentModelMapperXs2a, ConsentModelMapper consentModelMapper, PaymentAuthorisationService paymentAuthorisationService, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService, AuthorisationMapper authorisationMapper) {
        this.xs2aPaymentService = xs2aPaymentService;
        this.responseMapper = responseMapper;
        this.paymentModelMapperPsd2 = paymentModelMapperPsd2;
        this.paymentModelMapperXs2a = paymentModelMapperXs2a;
        this.consentModelMapper = consentModelMapper;
        this.paymentAuthorisationService = paymentAuthorisationService;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
        this.authorisationMapper = authorisationMapper;
    }
}

