/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.FundsConfirmationApi;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.service.FundsConfirmationService;
import de.adorsys.psd2.xs2a.service.mapper.FundsConfirmationModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the funds confirmation", tags={"Confirmation of Funds Service"})
public class FundsConfirmationController
implements FundsConfirmationApi {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationController.class);
    private final ResponseMapper responseMapper;
    private final FundsConfirmationService fundsConfirmationService;
    private final FundsConfirmationModelMapper fundsConfirmationModelMapper;

    public ResponseEntity checkAvailabilityOfFunds(ConfirmationOfFunds body, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate) {
        ResponseObject<FundsConfirmationResponse> responseObject = this.fundsConfirmationService.fundsConfirmation(this.fundsConfirmationModelMapper.mapToFundsConfirmationRequest(body));
        return this.responseMapper.ok(responseObject);
    }

    @ConstructorProperties(value={"responseMapper", "fundsConfirmationService", "fundsConfirmationModelMapper"})
    public FundsConfirmationController(ResponseMapper responseMapper, FundsConfirmationService fundsConfirmationService, FundsConfirmationModelMapper fundsConfirmationModelMapper) {
        this.responseMapper = responseMapper;
        this.fundsConfirmationService = fundsConfirmationService;
        this.fundsConfirmationModelMapper = fundsConfirmationModelMapper;
    }
}

