/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.AccountApi;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Xs2aBookingStatus;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.service.AccountService;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the account information", tags={"Account Information Service (AIS)"})
public class AccountController
implements AccountApi {
    private final HttpServletRequest request;
    private final AccountService accountService;
    private final ResponseMapper responseMapper;
    private final AccountModelMapper accountModelMapper;

    public ResponseEntity getAccountList(UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.accountService.getAccountList(consentID, Optional.ofNullable(withBalance).orElse(false)), this.accountModelMapper::mapToAccountList);
    }

    public ResponseEntity readAccountDetails(String accountId, UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.accountService.getAccountDetails(consentID, accountId, Optional.ofNullable(withBalance).orElse(false)), this.accountModelMapper::mapToAccountDetails);
    }

    public ResponseEntity getBalances(String accountId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.accountService.getBalancesReport(consentID, accountId), this.accountModelMapper::mapToBalance);
    }

    public ResponseEntity getTransactionList(String accountId, String bookingStatus, UUID xRequestID, String consentID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, Boolean deltaList, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aTransactionsReport> transactionsReport;
        block3: {
            block2: {
                transactionsReport = this.accountService.getTransactionsReportByPeriod(consentID, accountId, this.request.getHeader("accept"), BooleanUtils.isTrue((Boolean)withBalance), dateFrom, dateTo, Xs2aBookingStatus.forValue(bookingStatus));
                if (transactionsReport.hasError()) break block2;
                if (!transactionsReport.getBody().isResponseContentTypeJson()) break block3;
            }
            return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponse200Json);
        }
        return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponseRaw);
    }

    public ResponseEntity getTransactionDetails(String accountId, String resourceId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.accountService.getTransactionDetails(consentID, accountId, resourceId), this.accountModelMapper::mapToTransactionDetails);
    }

    @ConstructorProperties(value={"request", "accountService", "responseMapper", "accountModelMapper"})
    public AccountController(HttpServletRequest request, AccountService accountService, ResponseMapper responseMapper, AccountModelMapper accountModelMapper) {
        this.request = request;
        this.accountService = accountService;
        this.responseMapper = responseMapper;
        this.accountModelMapper = accountModelMapper;
    }
}

