/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class UpdatePisCancellationPsuDataAspect
extends AbstractLinkAspect<PaymentController> {
    private static final String PSU_CANCELLATION_AUTHORISATION_URL = "/v1/{paymentService}/{paymentId}/cancellation-authorisations/{authorisationId}";

    public UpdatePisCancellationPsuDataAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        super(aspspProfileService, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService.updatePisCancellationPsuData(..)) && args( request)", returning="result", argNames="result,request")
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorizationAspect(ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> result, Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        if (!result.hasError()) {
            Xs2aUpdatePisCommonPaymentPsuDataResponse body = result.getBody();
            Links links = this.buildLink(request);
            if (this.isScaStatusMethodAuthenticated(body.getScaStatus())) {
                links.setSelectAuthenticationMethod(this.buildAuthorisationLink(request.getPaymentService(), request.getPaymentId(), request.getAuthorisationId()));
                links.setUpdatePsuAuthentication(this.buildAuthorisationLink(request.getPaymentService(), request.getPaymentId(), request.getAuthorisationId()));
            } else if (this.isScaStatusMethodSelected(body.getChosenScaMethod(), body.getScaStatus())) {
                links.setAuthoriseTransaction(this.buildAuthorisationLink(request.getPaymentService(), request.getPaymentId(), request.getAuthorisationId()));
            } else if (this.isScaStatusFinalised(body.getScaStatus())) {
                links.setScaStatus(this.buildAuthorisationLink(request.getPaymentService(), request.getPaymentId(), request.getAuthorisationId()));
            }
            body.setLinks(links);
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLink(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{paymentService}/{paymentId}", request.getPaymentService(), request.getPaymentId()));
        links.setStatus(this.buildPath("/v1/{paymentService}/{paymentId}/status", request.getPaymentService(), request.getPaymentId()));
        return links;
    }

    private String buildAuthorisationLink(String paymentService, String paymentId, String authorisationId) {
        return this.buildPath(PSU_CANCELLATION_AUTHORISATION_URL, paymentService, paymentId, authorisationId);
    }

    private boolean isScaStatusFinalised(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.FINALISED;
    }

    private boolean isScaStatusMethodSelected(Xs2aAuthenticationObject chosenScaMethod, ScaStatus scaStatus) {
        return chosenScaMethod != null && scaStatus == ScaStatus.SCAMETHODSELECTED;
    }

    private boolean isScaStatusMethodAuthenticated(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUAUTHENTICATED;
    }
}

