/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreatePisAuthorisationCancellationAspect
extends AbstractLinkAspect<PaymentController> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorisationCancellationAspect.class);
    private final RedirectLinkBuilder redirectLinkBuilder;

    public CreatePisAuthorisationCancellationAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService, RedirectLinkBuilder redirectLinkBuilder) {
        super(aspspProfileService, messageService);
        this.redirectLinkBuilder = redirectLinkBuilder;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService.createPisCancellationAuthorization(..)) && args( paymentId, psuData, paymentType)", returning="result", argNames="result,paymentId,psuData,paymentType")
    public ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> createPisAuthorizationAspect(ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> result, String paymentId, PsuIdData psuData, PaymentType paymentType) {
        if (!result.hasError()) {
            Xs2aCreatePisCancellationAuthorisationResponse body = result.getBody();
            body.setLinks(this.buildLink(paymentType.getValue(), paymentId, body.getAuthorisationId()));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLink(String paymentService, String paymentId, String authorizationId) {
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentService, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentService, paymentId));
        if (this.aspspProfileService.getScaApproach() == ScaApproach.EMBEDDED) {
            return this.addEmbeddedRelatedLinks(links, paymentService, paymentId, authorizationId);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.REDIRECT) {
            return this.addRedirectRelatedLinks(links, paymentService, paymentId, authorizationId);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.OAUTH) {
            links.setScaOAuth("scaOAuth");
        }
        return links;
    }

    private Links addEmbeddedRelatedLinks(Links links, String paymentService, String paymentId, String authorizationId) {
        links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{paymentService}/{paymentId}/cancellation-authorisations/{authorisationId}", paymentService, paymentId, authorizationId));
        return links;
    }

    private Links addRedirectRelatedLinks(Links links, String paymentService, String paymentId, String authorizationId) {
        String link = this.redirectLinkBuilder.buildPaymentCancellationScaRedirectLink(paymentId, authorizationId);
        links.setScaRedirect(link);
        links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
        return links;
    }
}

