/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AccountAspect
extends AbstractLinkAspect<AccountController> {
    private static final Logger log = LoggerFactory.getLogger(AccountAspect.class);

    public AccountAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        super(aspspProfileService, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountDetails(..)) && args( consentId, accountId, withBalance)", returning="result", argNames="result,consentId,accountId,withBalance")
    public ResponseObject<Xs2aAccountDetails> getAccountDetailsAspect(ResponseObject<Xs2aAccountDetails> result, String consentId, String accountId, boolean withBalance) {
        if (!result.hasError()) {
            Xs2aAccountDetails accountDetails = result.getBody();
            accountDetails.setLinks(this.buildLinksForAccountDetails(accountDetails.getResourceId(), withBalance));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountList(..)) && args( consentId, withBalance)", returning="result", argNames="result,consentId,withBalance")
    public ResponseObject<Map<String, List<Xs2aAccountDetails>>> getAccountDetailsListAspect(ResponseObject<Map<String, List<Xs2aAccountDetails>>> result, String consentId, boolean withBalance) {
        if (!result.hasError()) {
            Map<String, List<Xs2aAccountDetails>> accountDetails = result.getBody();
            this.setLinksToAccounts(accountDetails, withBalance);
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionsReportByPeriod(..)) && args( consentId, accountId, withBalance, ..)", returning="result", argNames="result,consentId,accountId,withBalance")
    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aTransactionsReport> result, String consentId, String accountId, boolean withBalance) {
        if (!result.hasError()) {
            Xs2aTransactionsReport transactionsReport = result.getBody();
            if (transactionsReport.isTransactionReportHuge()) {
                Links links = new Links();
                links.setDownload(this.buildPath("/v1/accounts/{accountId}/transactions/download", accountId));
                transactionsReport.setLinks(links);
            } else {
                Xs2aAccountReport accountReport = transactionsReport.getAccountReport();
                accountReport.setLinks(this.buildLinksForAccountReport(accountId));
            }
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionDetails(..)) && args( consentID, accountId, resourceId)", returning="result", argNames="result,consentID,accountId,resourceId")
    public ResponseObject<Transactions> getTransactionDetailsAspect(ResponseObject<Transactions> result, String consentID, String accountId, String resourceId) {
        if (!result.hasError()) {
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLinksForAccountReport(String accountId) {
        Links links = new Links();
        links.setAccount(this.buildPath("/v1/accounts/{accountId}", accountId));
        return links;
    }

    private void setLinksToAccounts(Map<String, List<Xs2aAccountDetails>> accountDetailsMap, boolean withBalance) {
        for (Map.Entry<String, List<Xs2aAccountDetails>> entry : accountDetailsMap.entrySet()) {
            this.updateAccountLinks(entry.getValue(), withBalance);
        }
    }

    private void updateAccountLinks(List<Xs2aAccountDetails> accountDetailsList, boolean withBalance) {
        for (Xs2aAccountDetails acc : accountDetailsList) {
            this.setLinksToAccount(acc, withBalance);
        }
    }

    private void setLinksToAccount(Xs2aAccountDetails accountDetails, boolean withBalance) {
        accountDetails.setLinks(this.buildLinksForAccountDetails(accountDetails.getResourceId(), withBalance));
    }

    private Links buildLinksForAccountDetails(String accountId, boolean withBalance) {
        Links links = new Links();
        if (withBalance) {
            links.setViewBalances(this.buildPath("/v1/accounts/{accountId}/balances", accountId));
        }
        links.setViewTransactions(this.buildPath("/v1/accounts/{accountId}/transactions", accountId));
        return links;
    }
}

