/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;

public abstract class AbstractPaymentLink<T>
extends AbstractLinkAspect<T> {
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final RedirectLinkBuilder redirectLinkBuilder;

    public AbstractPaymentLink(AspspProfileServiceWrapper aspspProfileService, MessageService messageService, AuthorisationMethodDecider authorisationMethodDecider, RedirectLinkBuilder redirectLinkBuilder) {
        super(aspspProfileService, messageService);
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.redirectLinkBuilder = redirectLinkBuilder;
    }

    protected ResponseObject<?> enrichLink(ResponseObject<?> result, PaymentInitiationParameters paymentRequestParameters) {
        Object body = result.getBody();
        this.doEnrichLink(paymentRequestParameters, (PaymentInitiationResponse)body);
        return result;
    }

    private void doEnrichLink(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        body.setLinks(this.buildPaymentLinks(paymentRequestParameters, body));
    }

    private Links buildPaymentLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return null;
        }
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentService, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentService, paymentId));
        if (this.aspspProfileService.getScaApproach() == ScaApproach.EMBEDDED) {
            return this.addEmbeddedRelatedLinks(links, paymentRequestParameters, body);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.REDIRECT) {
            return this.addRedirectRelatedLinks(links, paymentRequestParameters, body);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.OAUTH) {
            links.setScaOAuth("scaOAuth");
        }
        return links;
    }

    private Links addEmbeddedRelatedLinks(Links links, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        String authorizationId = body.getAuthorizationId();
        if (this.authorisationMethodDecider.isExplicitMethod(paymentRequestParameters.isTppExplicitAuthorisationPreferred())) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations", paymentService, paymentId));
        } else {
            links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
            links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
        }
        return links;
    }

    private Links addRedirectRelatedLinks(Links links, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        String authorisationId = body.getAuthorizationId();
        if (this.authorisationMethodDecider.isExplicitMethod(paymentRequestParameters.isTppExplicitAuthorisationPreferred())) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations", paymentService, paymentId));
        } else {
            String scaRedirectLink = this.redirectLinkBuilder.buildPaymentScaRedirectLink(body.getPaymentId(), authorisationId);
            links.setScaRedirect(scaRedirectLink);
            links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorisationId));
        }
        return links;
    }
}

