/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.model.LinksSigningBasket;
import de.adorsys.psd2.model.SigningBasketResponse201;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.advice.CommonHeaderModifierAdvice;
import de.adorsys.psd2.xs2a.web.controller.SigningBasketController;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;

@ControllerAdvice(assignableTypes={SigningBasketController.class})
public class SigningBasketHeaderModifierAdvice
extends CommonHeaderModifierAdvice {
    public SigningBasketHeaderModifierAdvice(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(aspspProfileServiceWrapper);
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String methodName = returnType.getMethod().getName();
        if ("_createSigningBasket".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
            if (!this.hasError(body, SigningBasketResponse201.class)) {
                SigningBasketResponse201 signingBasketResponse = (SigningBasketResponse201)body;
                response.getHeaders().add("Location", (String)Optional.ofNullable(signingBasketResponse.getLinks()).map(LinksSigningBasket::getSelf).orElse(null));
            }
        } else if ("_startSigningBasketAuthorisation".equals(methodName) || "_updateSigningBasketPsuData".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
        }
        return body;
    }
}

