/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.advice.CommonHeaderModifierAdvice;
import de.adorsys.psd2.xs2a.web.controller.ConsentController;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;

@ControllerAdvice(assignableTypes={ConsentController.class})
public class ConsentHeaderModifierAdvice
extends CommonHeaderModifierAdvice {
    public ConsentHeaderModifierAdvice(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(aspspProfileServiceWrapper);
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String methodName = returnType.getMethod().getName();
        if ("_createConsent".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
            if (!this.hasError(body, ConsentsResponse201.class)) {
                ConsentsResponse201 consentResponse = (ConsentsResponse201)body;
                response.getHeaders().add("Location", (String)Optional.ofNullable(consentResponse.getLinks().get("self")).map(Object::toString).orElse(null));
            }
        } else if ("_startConsentAuthorisation".equals(methodName) || "_updateConsentsPsuData".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
        }
        return body;
    }
}

