/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.header;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.service.validator.header.RequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.AccountRequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.ConsentRequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.ErrorMessageHeaderImpl;
import de.adorsys.psd2.xs2a.service.validator.header.impl.FundsConfirmationRequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.NotMatchedHeaderImpl;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import de.adorsys.psd2.xs2a.web.controller.ConsentController;
import de.adorsys.psd2.xs2a.web.controller.FundsConfirmationController;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersFactory.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<Class, Class> controllerClassMap = new HashMap<Class, Class>();

    public static RequestHeader getHeadersImpl(Map<String, String> requestHeadersMap, Class controllerClass) {
        return HeadersFactory.getHeadersImplByRequestHeaderClass(requestHeadersMap, controllerClassMap.get(controllerClass));
    }

    public static RequestHeader getHeadersImplByRequestHeaderClass(Map<String, String> requestHeadersMap, Class<? extends RequestHeader> headerClass) {
        if (headerClass == null) {
            return new NotMatchedHeaderImpl();
        }
        try {
            return (RequestHeader)MAPPER.convertValue(requestHeadersMap, headerClass);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.error("Error request headers conversion: " + exception.getMessage());
            return new ErrorMessageHeaderImpl(exception.getMessage());
        }
    }

    static {
        controllerClassMap.put(AccountController.class, AccountRequestHeader.class);
        controllerClassMap.put(ConsentController.class, ConsentRequestHeader.class);
        controllerClassMap.put(FundsConfirmationController.class, FundsConfirmationRequestHeader.class);
    }
}

